/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    public static final String ALL_COLUMNS_PATTERN = "*";
    public static final String MATCH_ANY_PATTERN = "%";
    private final SQLCompletionRequest request;
    private DBRProgressMonitor monitor;
    final List<SQLCompletionProposalBase> proposals = new ArrayList<SQLCompletionProposalBase>();
    boolean searchFinished = false;

    public SQLCompletionAnalyzer(SQLCompletionRequest request) {
        this.request = request;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.runAnalyzer(monitor);
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<SQLCompletionProposalBase> getProposals() {
        return this.proposals;
    }

    public boolean isSearchFinished() {
        return this.searchFinished;
    }

    public void runAnalyzer(DBRProgressMonitor monitor) throws DBException {
        this.monitor = monitor;
        this.runAnalyzer();
    }

    private void runAnalyzer() throws DBException {
        String searchPrefix = this.request.getWordPart();
        this.request.setQueryType(null);
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        SQLSyntaxManager syntaxManager = this.request.getContext().getSyntaxManager();
        String prevKeyWord = this.request.getWordDetector().getPrevKeyWord();
        if (!CommonUtils.isEmpty((String)prevKeyWord)) {
            if (syntaxManager.getDialect().isEntityQueryWord(prevKeyWord)) {
                if ("INTO".equals(prevKeyWord) && !CommonUtils.isEmpty(this.request.getWordDetector().getPrevWords()) && ("(".equals(this.request.getWordDetector().getPrevDelimiter()) || ",".equals(wordDetector.getPrevDelimiter()))) {
                    this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                } else if ("JOIN".equals(prevKeyWord)) {
                    this.request.setQueryType(SQLCompletionRequest.QueryType.JOIN);
                } else {
                    this.request.setQueryType(SQLCompletionRequest.QueryType.TABLE);
                }
            } else if (syntaxManager.getDialect().isAttributeQueryWord(prevKeyWord)) {
                this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                if (!this.request.isSimpleMode() && CommonUtils.isEmpty((String)this.request.getWordPart()) && wordDetector.getPrevDelimiter().equals(ALL_COLUMNS_PATTERN)) {
                    wordDetector.moveToDelimiter();
                    searchPrefix = ALL_COLUMNS_PATTERN;
                }
            } else if (SQLUtils.isExecQuery((SQLDialect)syntaxManager.getDialect(), (String)prevKeyWord)) {
                this.request.setQueryType(SQLCompletionRequest.QueryType.EXEC);
            }
        }
        this.request.setWordPart(searchPrefix);
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource == null) {
            return;
        }
        String wordPart = this.request.getWordPart();
        boolean emptyWord = wordPart.length() == 0;
        SQLCompletionRequest.QueryType queryType = this.request.getQueryType();
        if (queryType != null) {
            DBSObject selectedObject;
            DBSObjectContainer sc;
            DBSObject rootObject;
            if (emptyWord) {
                DBSObject leftTable;
                rootObject = null;
                if (queryType == SQLCompletionRequest.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    rootObject = this.getTableFromAlias((DBSObjectContainer)dataSource, null);
                    if (rootObject instanceof DBSEntity && "ON".equals(wordDetector.getPrevKeyWord()) && this.makeJoinColumnProposals((DBSObjectContainer)dataSource, (DBSEntity)rootObject)) {
                        return;
                    }
                } else if (dataSource instanceof DBSObjectContainer) {
                    DBSObject selectedObject2 = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                    if (selectedObject2 != null) {
                        this.makeProposalsFromChildren((DBPObject)selectedObject2, null, false);
                        rootObject = DBUtils.getPublicObject((DBPObject)selectedObject2.getParentObject());
                    } else {
                        rootObject = dataSource;
                    }
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, null, false);
                }
                if (queryType == SQLCompletionRequest.QueryType.JOIN && !this.proposals.isEmpty() && dataSource instanceof DBSObjectContainer && (leftTable = this.getTableFromAlias((DBSObjectContainer)dataSource, null)) instanceof DBSEntity) {
                    this.filterNonJoinableProposals((DBSEntity)leftTable);
                }
            } else {
                rootObject = null;
                if (queryType == SQLCompletionRequest.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    int divPos;
                    String tableAlias;
                    sc = (DBSObjectContainer)dataSource;
                    selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                    if (selectedObject instanceof DBSObjectContainer) {
                        sc = (DBSObjectContainer)selectedObject;
                    }
                    String string = tableAlias = (divPos = wordPart.lastIndexOf(syntaxManager.getStructSeparator())) == -1 ? null : wordPart.substring(0, divPos);
                    if (tableAlias == null && !CommonUtils.isEmpty((String)wordPart) && (rootObject = this.getTableFromAlias(sc, wordPart)) != null) {
                        this.searchFinished = true;
                        return;
                    }
                    rootObject = this.getTableFromAlias(sc, tableAlias);
                    if (rootObject == null && tableAlias != null) {
                        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)this.request.getContext().getDataSource());
                        String[] allNames = SQLUtils.splitFullIdentifier((String)tableAlias, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
                        rootObject = SQLSearchUtils.findObjectByFQN(this.monitor, sc, dataSource, Arrays.asList(allNames), !this.request.isSimpleMode(), this.request.getWordDetector());
                    }
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, wordPart, false);
                } else if (queryType != SQLCompletionRequest.QueryType.COLUMN && queryType != SQLCompletionRequest.QueryType.EXEC) {
                    this.makeDataSourceProposals();
                }
            }
            if (!this.request.isSimpleMode() && (queryType == SQLCompletionRequest.QueryType.EXEC || queryType == SQLCompletionRequest.QueryType.COLUMN && this.request.getContext().isSearchProcedures()) && dataSource instanceof DBSObjectContainer) {
                DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
                sc = (DBSObjectContainer)dataSource;
                selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                if (selectedObject instanceof DBSObjectContainer) {
                    sc = (DBSObjectContainer)selectedObject;
                }
                if (structureAssistant != null) {
                    this.makeProposalsFromAssistant(structureAssistant, sc, new DBSObjectType[]{RelationalObjectType.TYPE_PROCEDURE}, wordPart);
                }
            }
        }
        if (!emptyWord) {
            this.makeProposalsFromQueryParts();
        }
        if (!this.searchFinished && !CommonUtils.isEmpty((String)this.request.getWordPart())) {
            List matchedKeywords = syntaxManager.getDialect().getMatchedKeywords(this.request.getWordPart());
            if (!this.request.isSimpleMode()) {
                matchedKeywords.sort(Comparator.comparingInt(o -> TextUtils.fuzzyScore(o, this.request.getWordPart())));
            }
            for (String keyWord : matchedKeywords) {
                DBPKeywordType keywordType = syntaxManager.getDialect().getKeywordType(keyWord);
                if (keywordType == null || keywordType == DBPKeywordType.TYPE || this.request.getQueryType() == SQLCompletionRequest.QueryType.COLUMN && keywordType != DBPKeywordType.FUNCTION && keywordType != DBPKeywordType.KEYWORD) continue;
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, keyWord, keyWord, keywordType, null, false, null));
            }
        }
        this.filterProposals(dataSource);
    }

    private void filterProposals(DBPDataSource dataSource) {
        boolean hideDups;
        HashSet<String> proposalMap = new HashSet<String>(this.proposals.size());
        int i = 0;
        while (i < this.proposals.size()) {
            SQLCompletionProposalBase proposal = this.proposals.get(i);
            if (proposalMap.contains(proposal.getDisplayString())) {
                this.proposals.remove(i);
                continue;
            }
            proposalMap.add(proposal.getDisplayString());
            ++i;
        }
        DBSInstance defaultInstance = dataSource == null ? null : dataSource.getDefaultInstance();
        DBSObject selectedObject = defaultInstance == null ? null : DBUtils.getActiveInstanceObject((DBSInstance)defaultInstance);
        boolean bl = hideDups = this.request.getContext().isHideDuplicates() && selectedObject != null;
        if (hideDups) {
            int i2 = 0;
            while (i2 < this.proposals.size()) {
                SQLCompletionProposalBase proposal = this.proposals.get(i2);
                int n = 0;
                while (n < this.proposals.size()) {
                    SQLCompletionProposalBase proposal2 = this.proposals.get(n);
                    if (i2 != n && proposal.hasStructObject() && proposal2.hasStructObject() && CommonUtils.equalObjects((Object)proposal.getObject().getName(), (Object)proposal2.getObject().getName()) && proposal.getObjectContainer() == selectedObject) {
                        this.proposals.remove(n);
                        continue;
                    }
                    ++n;
                }
                ++i2;
            }
        }
        if (hideDups) {
            boolean cfr_ignored_0 = selectedObject instanceof DBSObjectContainer;
        }
        if (dataSource != null) {
            DBPDataSourceContainer dsContainer = dataSource.getContainer();
            HashMap<DBSObject, Map> containerMap = new HashMap<DBSObject, Map>();
            for (SQLCompletionProposalBase sQLCompletionProposalBase : this.proposals) {
                DBSObject container = sQLCompletionProposalBase.getObjectContainer();
                DBPNamedObject object = sQLCompletionProposalBase.getObject();
                if (object == null) continue;
                Map typeMap = containerMap.computeIfAbsent(container, k -> new HashMap());
                Class objectType = object instanceof DBSObjectReference ? ((DBSObjectReference)object).getObjectClass() : object.getClass();
                List list = typeMap.computeIfAbsent(objectType, k -> new ArrayList());
                list.add(sQLCompletionProposalBase);
            }
            for (Map.Entry entry : containerMap.entrySet()) {
                for (Map.Entry typeEntry : ((Map)entry.getValue()).entrySet()) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter((Class)typeEntry.getKey(), (DBSObject)entry.getKey(), true);
                    if (filter == null || !filter.isEnabled()) continue;
                    for (SQLCompletionProposalBase proposal : (List)typeEntry.getValue()) {
                        if (filter.matches(proposal.getObject().getName())) continue;
                        this.proposals.remove(proposal);
                    }
                }
            }
        }
    }

    private void makeProposalsFromQueryParts() {
        String wordPart = this.request.getWordPart();
        if (!CommonUtils.isEmpty((String)this.request.getActiveQuery().getText()) && !CommonUtils.isEmpty((String)wordPart)) {
            if (wordPart.indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) != -1 || wordPart.equals(ALL_COLUMNS_PATTERN)) {
                return;
            }
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)this.request.getContext().getDataSource());
            String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
            String tableAliasPattern = this.getTableAliasPattern("(" + wordPart + "[a-z]*)", tableNamePattern);
            Pattern rp = Pattern.compile(tableAliasPattern);
            Matcher matcher = rp.matcher(String.valueOf(this.request.getActiveQuery().getText()) + " ");
            while (matcher.find()) {
                String tableName = matcher.group(1);
                String tableAlias = matcher.group(2);
                if (tableAlias.equals(wordPart)) continue;
                this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableName, tableName, DBPKeywordType.OTHER, null, false, null));
                this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableAlias, tableAlias, DBPKeywordType.OTHER, null, false, null));
            }
        }
    }

    private boolean makeJoinColumnProposals(DBSObjectContainer sc, DBSEntity leftTable) {
        SQLWordPartDetector joinTableDetector = new SQLWordPartDetector(this.request.getDocument(), this.request.getContext().getSyntaxManager(), this.request.getWordDetector().getStartOffset(), 2);
        List<String> prevWords = joinTableDetector.getPrevWords();
        if (!CommonUtils.isEmpty(prevWords)) {
            DBPDataSource dataSource = this.request.getContext().getDataSource();
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
            String rightTableName = prevWords.get(0);
            String[] allNames = SQLUtils.splitFullIdentifier((String)rightTableName, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
            DBSObject rightTable = SQLSearchUtils.findObjectByFQN(this.monitor, sc, dataSource, Arrays.asList(allNames), !this.request.isSimpleMode(), this.request.getWordDetector());
            if (rightTable instanceof DBSEntity) {
                try {
                    String joinCriteria = SQLUtils.generateTableJoin((DBRProgressMonitor)this.monitor, (DBSEntity)leftTable, (String)DBUtils.getQuotedIdentifier((DBSObject)leftTable), (DBSEntity)((DBSEntity)rightTable), (String)DBUtils.getQuotedIdentifier((DBSObject)rightTable));
                    this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, joinCriteria, joinCriteria, DBPKeywordType.OTHER, "Join condition"));
                    return true;
                }
                catch (DBException e) {
                    log.error((Object)"Error generating join condition", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void filterNonJoinableProposals(DBSEntity leftTable) {
        ArrayList<SQLCompletionProposalBase> joinableProposals = new ArrayList<SQLCompletionProposalBase>();
        for (SQLCompletionProposalBase proposal : this.proposals) {
            DBSEntity rightTable;
            if (!(proposal.getObject() instanceof DBSEntity) || !this.tableHaveJoins(rightTable = (DBSEntity)proposal.getObject(), leftTable) && !this.tableHaveJoins(leftTable, rightTable)) continue;
            proposal.setReplacementAfter(" ON");
            joinableProposals.add(proposal);
        }
        if (!joinableProposals.isEmpty()) {
            this.proposals.clear();
            this.proposals.addAll(joinableProposals);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableHaveJoins(DBSEntity table1, DBSEntity table2) {
        try {
            Collection associations = table1.getAssociations(this.monitor);
            if (!CommonUtils.isEmpty((Collection)associations)) {
                for (DBSEntityAssociation fk : associations) {
                    if (fk.getAssociatedEntity() != table2) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    private void makeDataSourceProposals() throws DBException {
        Object sc;
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (rootContainer == null) {
            return;
        }
        DBSObjectContainer childObject = sc = rootContainer;
        String[] tokens = this.request.getWordDetector().splitWordPart();
        DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBRProgressMonitor)this.monitor, (DBSObject)dataSource);
        DBSObjectContainer[] selectedContainers = new DBSObjectContainer[selectedObjects.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedContainers[i] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObjects[i]);
            ++i;
        }
        String lastToken = null;
        i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (i == tokens.length - 1 && !this.request.getWordDetector().getWordPart().endsWith(".")) {
                lastToken = token;
                break;
            }
            if (sc == null) break;
            String objectName = this.request.getWordDetector().isQuoted(token) ? this.request.getWordDetector().removeQuotes(token) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)token);
            DBSObject dBSObject = childObject = objectName == null ? null : sc.getChild(this.monitor, objectName);
            if (childObject == null && i == 0 && objectName != null) {
                int k = 0;
                while (k < selectedContainers.length) {
                    if (selectedContainers[k] != null && (childObject = selectedContainers[k].getChild(this.monitor, objectName)) != null) {
                        sc = selectedContainers[k];
                        break;
                    }
                    ++k;
                }
            }
            if (childObject == null) {
                if (i == 0) {
                    List references;
                    DBSStructureAssistant structureAssistant;
                    childObject = this.getTableFromAlias((DBSObjectContainer)sc, token);
                    if (childObject == null && !this.request.isSimpleMode() && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null && !(references = structureAssistant.findObjectsByMask(this.monitor, null, structureAssistant.getAutoCompleteObjectTypes(), this.request.getWordDetector().removeQuotes(token), this.request.getWordDetector().isQuoted(token), false, 2)).isEmpty()) {
                        childObject = ((DBSObjectReference)references.iterator().next()).resolveObject(this.monitor);
                    }
                } else {
                    return;
                }
            }
            sc = childObject instanceof DBSObjectContainer ? childObject : null;
            ++i;
        }
        if (childObject == null) {
            return;
        }
        if (lastToken == null) {
            this.makeProposalsFromChildren((DBPObject)childObject, null, false);
        } else {
            this.makeProposalsFromChildren((DBPObject)childObject, lastToken, false);
            int cfr_ignored_0 = tokens.length;
            if (tokens.length == 1) {
                int k = 0;
                while (k < selectedContainers.length) {
                    if (selectedContainers[k] != null && selectedContainers[k] != childObject) {
                        this.makeProposalsFromChildren((DBPObject)selectedContainers[k], lastToken, true);
                    }
                    ++k;
                }
                if (this.proposals.isEmpty() && !this.request.isSimpleMode()) {
                    DBSStructureAssistant structureAssistant = null;
                    DBSObjectContainer object = childObject;
                    while (object != null) {
                        structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)object);
                        if (structureAssistant != null) break;
                        object = object.getParentObject();
                    }
                    if (structureAssistant != null) {
                        this.makeProposalsFromAssistant(structureAssistant, (DBSObjectContainer)sc, null, lastToken);
                    }
                }
            }
        }
    }

    @Nullable
    private DBSObject getTableFromAlias(DBSObjectContainer sc, @Nullable String token) {
        Pattern aliasPattern;
        String structNamePattern;
        if (token == null) {
            token = "";
        } else if (token.equals(ALL_COLUMNS_PATTERN)) {
            return null;
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (!(dataSource instanceof SQLDataSource)) {
            return null;
        }
        if (this.request.getActiveQuery() == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
        if (CommonUtils.isEmpty((String)token)) {
            String kwList = "from|update|join|into";
            if (this.request.getQueryType() != SQLCompletionRequest.QueryType.COLUMN) {
                kwList = String.valueOf(kwList) + "|,";
            }
            structNamePattern = "(?:" + kwList + ")\\s+" + tableNamePattern;
        } else {
            structNamePattern = this.getTableAliasPattern(token, tableNamePattern);
        }
        try {
            aliasPattern = Pattern.compile(structNamePattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        String testQuery = String.valueOf(SQLUtils.stripComments((SQLDialect)this.request.getContext().getSyntaxManager().getDialect(), (String)this.request.getActiveQuery().getText())) + " ";
        Matcher matcher = aliasPattern.matcher(testQuery);
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            int i = 1;
            while (i <= groupCount) {
                String group = matcher.group(i);
                if (!CommonUtils.isEmpty((String)group)) {
                    String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
                    String[] allNames = SQLUtils.splitFullIdentifier((String)group, (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
                    Collections.addAll(nameList, allNames);
                }
                ++i;
            }
        }
        return SQLSearchUtils.findObjectByFQN(this.monitor, sc, dataSource, nameList, !this.request.isSimpleMode(), this.request.getWordDetector());
    }

    private String getTableAliasPattern(String alias, String tableNamePattern) {
        return String.valueOf(tableNamePattern) + "\\s+(?:as\\s)?" + alias + "[\\s,]+";
    }

    private static String getTableNamePattern(SQLDialect sqlDialect) {
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        StringBuilder quotes = new StringBuilder();
        if (quoteStrings != null) {
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] quotePair = stringArray[n2];
                if (quotes.indexOf(quotePair[0]) == -1) {
                    quotes.append('\\').append(quotePair[0]);
                }
                if (quotes.indexOf(quotePair[1]) == -1) {
                    quotes.append('\\').append(quotePair[1]);
                }
                ++n2;
            }
        }
        return "([\\p{L}0-9_$\u00a7#@\\.\\-" + quotes.toString() + "]+)";
    }

    private void makeProposalsFromChildren(DBPObject parent, @Nullable String startPart, boolean addFirst) throws DBException {
        int divPos;
        if (this.request.getQueryType() == SQLCompletionRequest.QueryType.EXEC) {
            return;
        }
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        if (startPart != null && (divPos = (startPart = wordDetector.removeQuotes(startPart).toUpperCase(Locale.ENGLISH)).lastIndexOf(this.request.getContext().getSyntaxManager().getStructSeparator())) != -1) {
            startPart = startPart.substring(divPos + 1);
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        Collection children = null;
        if (parent instanceof DBSObjectContainer) {
            children = ((DBSObjectContainer)parent).getChildren(this.monitor);
        } else if (parent instanceof DBSEntity) {
            children = ((DBSEntity)parent).getAttributes(this.monitor);
        }
        if (children != null && !children.isEmpty()) {
            String prevWord;
            ArrayList<DBSObject> matchedObjects = new ArrayList<DBSObject>();
            HashMap<String, Integer> scoredMatches = new HashMap<String, Integer>();
            boolean simpleMode = this.request.isSimpleMode();
            boolean allObjects = !simpleMode && ALL_COLUMNS_PATTERN.equals(startPart);
            String objPrefix = null;
            if (allObjects && !CommonUtils.isEmpty(wordDetector.getPrevWords()) && (prevWord = wordDetector.getPrevWords().get(0)).length() > 0 && prevWord.charAt(prevWord.length() - 1) == this.request.getContext().getSyntaxManager().getStructSeparator()) {
                objPrefix = prevWord;
            }
            StringBuilder combinedMatch = new StringBuilder();
            for (DBSObject child : children) {
                int score;
                if (DBUtils.isHiddenObject((Object)child)) continue;
                if (allObjects) {
                    if (combinedMatch.length() > 0) {
                        combinedMatch.append(", ");
                        if (objPrefix != null) {
                            combinedMatch.append(objPrefix);
                        }
                    }
                    combinedMatch.append(DBUtils.getQuotedIdentifier((DBSObject)child));
                    continue;
                }
                if (dataSource != null && !this.request.getContext().isSearchInsideNames()) {
                    if (!CommonUtils.isEmpty((String)startPart) && !CommonUtils.startsWithIgnoreCase((String)child.getName(), (String)startPart)) continue;
                    matchedObjects.add(child);
                    continue;
                }
                int n = score = CommonUtils.isEmpty((String)startPart) ? 1 : TextUtils.fuzzyScore(child.getName(), startPart);
                if (score <= 0) continue;
                matchedObjects.add(child);
                scoredMatches.put(child.getName(), score);
            }
            if (combinedMatch.length() > 0) {
                String replaceString = combinedMatch.toString();
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, replaceString, DBPKeywordType.OTHER, "All objects"));
            } else if (!matchedObjects.isEmpty()) {
                if (startPart == null || scoredMatches.isEmpty()) {
                    if (dataSource != null && this.request.getContext().isSortAlphabetically()) {
                        matchedObjects.sort(DBUtils.nameComparatorIgnoreCase());
                    }
                } else {
                    matchedObjects.sort((o1, o2) -> {
                        int score2;
                        int score1 = (Integer)scoredMatches.get(o1.getName());
                        if (score1 == (score2 = ((Integer)scoredMatches.get(o2.getName())).intValue())) {
                            if (o1 instanceof DBSAttributeBase) {
                                return ((DBSAttributeBase)o1).getOrdinalPosition() - ((DBSAttributeBase)o2).getOrdinalPosition();
                            }
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                        return score2 - score1;
                    });
                }
                ArrayList<SQLCompletionProposalBase> childProposals = new ArrayList<SQLCompletionProposalBase>(matchedObjects.size());
                for (DBSObject child : matchedObjects) {
                    SQLCompletionProposalBase proposal = this.makeProposalsFromObject(child, !(parent instanceof DBPDataSource));
                    if (!scoredMatches.isEmpty()) {
                        int proposalScore = (Integer)scoredMatches.get(child.getName());
                        proposal.setProposalScore(proposalScore);
                    }
                    childProposals.add(proposal);
                }
                if (addFirst) {
                    this.proposals.addAll(0, childProposals);
                } else {
                    this.proposals.addAll(childProposals);
                }
            }
        }
    }

    private boolean objectNameMatches(@Nullable String startPart, DBSObject child, boolean matchContains) {
        String nameCI = child.getName().toUpperCase(Locale.ENGLISH);
        return !CommonUtils.isEmpty((String)startPart) && (matchContains ? nameCI.contains(startPart) : nameCI.startsWith(startPart));
    }

    private void makeProposalsFromAssistant(DBSStructureAssistant assistant, @Nullable DBSObjectContainer rootSC, DBSObjectType[] objectTypes, String objectName) throws DBException {
        List references = assistant.findObjectsByMask(this.monitor, (DBSObject)rootSC, objectTypes == null ? assistant.getAutoCompleteObjectTypes() : objectTypes, this.makeObjectNameMask(this.request.getWordDetector().removeQuotes(objectName)), this.request.getWordDetector().isQuoted(objectName), this.request.getContext().isSearchGlobally(), 100);
        for (DBSObjectReference reference : references) {
            this.proposals.add(this.makeProposalsFromObject((DBPNamedObject)reference, !(rootSC instanceof DBPDataSource), reference.getObjectType().getImage()));
        }
    }

    private String makeObjectNameMask(String objectName) {
        if (this.request.getContext().isSearchInsideNames()) {
            return MATCH_ANY_PATTERN + objectName + MATCH_ANY_PATTERN;
        }
        return String.valueOf(objectName) + MATCH_ANY_PATTERN;
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBSObject object, boolean useShortName) {
        DBPImage objectIcon;
        DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)this.monitor, (DBSObject)object, (boolean)false);
        DBPImage dBPImage = objectIcon = node == null ? null : node.getNodeIconDefault();
        if (objectIcon == null) {
            objectIcon = DBValueFormatting.getObjectImage((DBPObject)object);
        }
        return this.makeProposalsFromObject((DBPNamedObject)object, useShortName, objectIcon);
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBPNamedObject object, boolean useShortName, @Nullable DBPImage objectIcon) {
        String alias = null;
        if ("FROM".equals(this.request.getWordDetector().getPrevKeyWord()) && object instanceof DBSEntity && ((DBSEntity)object).getDataSource().getContainer().getPreferenceStore().getBoolean("sql.proposals.insert.table.alias")) {
            Statement sqlStatement;
            String queryText = this.request.getActiveQuery().getText();
            final LinkedHashSet aliases = new LinkedHashSet();
            if (this.request.getActiveQuery() instanceof SQLQuery && (sqlStatement = ((SQLQuery)this.request.getActiveQuery()).getStatement()) != null) {
                TablesNamesFinder namesFinder = new TablesNamesFinder(){

                    public void visit(Table table) {
                        if (table.getAlias() != null && table.getAlias().getName() != null) {
                            aliases.add(table.getAlias().getName().toLowerCase(Locale.ENGLISH));
                        }
                    }
                };
                sqlStatement.accept((StatementVisitor)namesFinder);
            }
            alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)object), s -> aliases.contains(s) || queryText.contains(" as " + s));
        }
        String objectName = useShortName ? object.getName() : DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        boolean isSingleObject = true;
        String replaceString = null;
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource != null) {
            DBSObject selectedObject;
            DBSObjectReference structObject;
            if (!this.request.getContext().isUseShortNames() && object instanceof DBSObjectReference && this.request.getWordDetector().getFullWord().indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) == -1 && (structObject = (DBSObjectReference)object).getContainer() != null && (selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance())) != structObject.getContainer()) {
                replaceString = structObject.getFullyQualifiedName(DBPEvaluationContext.DML);
                isSingleObject = false;
            }
            if (replaceString == null) {
                replaceString = this.request.getContext().isUseFQNames() && object instanceof DBPQualifiedObject ? ((DBPQualifiedObject)object).getFullyQualifiedName(DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)object.getName());
            }
        } else {
            replaceString = DBUtils.getObjectShortName((Object)object);
        }
        if (!CommonUtils.isEmpty(alias)) {
            replaceString = String.valueOf(replaceString) + " " + alias;
        }
        return SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, objectName, DBPKeywordType.OTHER, objectIcon, isSingleObject, object);
    }

    static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, @Nullable DBPImage image, boolean isObject, @Nullable DBPNamedObject object) {
        boolean quotedString;
        DBPDataSource dataSource = request.getContext().getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        if (!(quotedString = request.getWordDetector().isQuoted(replaceString))) {
            replaceString = SQLCompletionAnalyzer.convertKeywordCase(request, replaceString, isObject);
        }
        return request.getContext().createProposal(request, displayString, replaceString, replaceString.length(), image, proposalType, null, object);
    }

    private static String convertKeywordCase(SQLCompletionRequest request, String replaceString, boolean isObject) {
        int proposalCase = request.getContext().getInsertCase();
        switch (proposalCase) {
            case 1: {
                replaceString = replaceString.toUpperCase();
                break;
            }
            case 2: {
                replaceString = replaceString.toLowerCase();
                break;
            }
            default: {
                if (isObject) break;
                SQLDialect dialect = request.getContext().getSyntaxManager().getDialect();
                DBPKeywordType keywordType = dialect.getKeywordType(replaceString);
                replaceString = keywordType == DBPKeywordType.KEYWORD ? request.getContext().getSyntaxManager().getKeywordCase().transform(replaceString) : dialect.storesUnquotedCase().transform(replaceString);
            }
        }
        return replaceString;
    }

    protected static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, String description) {
        return request.getContext().createProposal(request, displayString, replaceString, replaceString.length(), null, proposalType, description, null);
    }
}

