/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm;

import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.utils.CommonUtils;

public enum QMObjectType {
    session("Session", QMMSessionInfo.class),
    txn("Transactions", QMMTransactionInfo.class),
    query("Queries", QMMStatementInfo.class);

    private final String title;
    private final Class<? extends QMMObject> type;

    private QMObjectType(String title, Class<? extends QMMObject> type) {
        this.title = title;
        this.type = type;
    }

    public Class<? extends QMMObject> getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public static String toString(Collection<QMObjectType> objectTypes) {
        ArrayList<String> names = new ArrayList<String>(objectTypes.size());
        for (QMObjectType type : objectTypes) {
            names.add(type.name());
        }
        return CommonUtils.makeString(names, (char)',');
    }

    public static Collection<QMObjectType> fromString(String str) {
        ArrayList<QMObjectType> objectTypes = new ArrayList<QMObjectType>();
        for (String otName : CommonUtils.splitString((String)str, (char)',')) {
            try {
                objectTypes.add(QMObjectType.valueOf(otName));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return objectTypes;
    }
}

