/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.Pair;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner {
    private final List<IPredicateRule> rules = new ArrayList<IPredicateRule>();
    private final IToken commentToken = new Token((Object)"sql_comment");
    private final IToken multilineCommentToken = new Token((Object)"sql_multiline_comment");
    private final IToken sqlStringToken = new Token((Object)"sql_character");
    private final IToken sqlQuotedToken = new Token((Object)"sql_quoted");

    private void setupRules() {
        IPredicateRule[] result = new IPredicateRule[this.rules.size()];
        this.rules.toArray(result);
        this.setPredicateRules(result);
    }

    private void initRules(SQLDialect dialect) {
        String[] singleLineComments;
        int n;
        int n2;
        String[][] stringArray;
        SQLRuleProvider ruleProvider = (SQLRuleProvider)GeneralUtils.adapt((Object)dialect, SQLRuleProvider.class);
        if (ruleProvider != null) {
            ArrayList<IRule> partRules = new ArrayList<IRule>();
            ruleProvider.extendRules(partRules, SQLRuleProvider.RulePosition.PARTITION);
            for (IRule pr : partRules) {
                if (!(pr instanceof IPredicateRule)) continue;
                this.rules.add((IPredicateRule)pr);
            }
        }
        boolean hasDoubleQuoteRule = false;
        String[][] identifierQuoteStrings = dialect.getIdentifierQuoteStrings();
        String[][] stringQuoteStrings = dialect.getStringQuoteStrings();
        if (identifierQuoteStrings != null) {
            stringArray = identifierQuoteStrings;
            n2 = identifierQuoteStrings.length;
            n = 0;
            while (n < n2) {
                String[] quoteString = stringArray[n];
                this.rules.add((IPredicateRule)new MultiLineRule(quoteString[0], quoteString[1], this.sqlQuotedToken, dialect.getStringEscapeCharacter()));
                if (quoteString[1].equals("\"") && quoteString[0].equals(quoteString[1])) {
                    hasDoubleQuoteRule = true;
                }
                ++n;
            }
        }
        if (!hasDoubleQuoteRule) {
            this.rules.add((IPredicateRule)new MultiLineRule("\"", "\"", this.sqlQuotedToken, dialect.getStringEscapeCharacter()));
        }
        if (!ArrayUtils.isEmpty((Object[])stringQuoteStrings)) {
            stringArray = stringQuoteStrings;
            n2 = stringQuoteStrings.length;
            n = 0;
            while (n < n2) {
                String[] quotes = stringArray[n];
                this.rules.add((IPredicateRule)new MultiLineRule(quotes[0], quotes[1], this.sqlStringToken, dialect.getStringEscapeCharacter()));
                ++n;
            }
        }
        EmptyCommentRule wordRule = new EmptyCommentRule(this.multilineCommentToken);
        this.rules.add(wordRule);
        Pair multiLineComments = dialect.getMultiLineComments();
        if (multiLineComments != null) {
            this.rules.add((IPredicateRule)new MultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), this.multilineCommentToken, '\u0000', true));
        }
        String[] stringArray2 = singleLineComments = dialect.getSingleLineComments();
        int n3 = singleLineComments.length;
        int n4 = 0;
        while (n4 < n3) {
            String singleLineComment = stringArray2[n4];
            this.rules.add((IPredicateRule)new EndOfLineRule(singleLineComment, this.commentToken));
            ++n4;
        }
    }

    public SQLPartitionScanner(SQLDialect dialect) {
        this.initRules(dialect);
        this.setupRules();
    }

    public String getScannedPartitionString() {
        try {
            return this.fDocument.get(this.fPartitionOffset, this.fOffset - this.fPartitionOffset);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___sql_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {}
        return regions;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken successToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.successToken = successToken;
            this.addWord("/**/", this.successToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.successToken;
        }
    }
}

