/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class DB2PlanInstance {
    private static String SEL_EXP_STATEMENT;
    private DB2PlanStatement db2PlanStatement;
    private String statement_id;
    private String explainRequester;
    private Timestamp explainTime;
    private String sourceName;
    private String sourceSchema;
    private String sourceVersion;

    static {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("SELECT *");
        sb.append(" FROM EXPLAIN_STATEMENT");
        sb.append(" WHERE EXPLAIN_REQUESTER = ?");
        sb.append("   AND EXPLAIN_TIME = ?");
        sb.append("   AND SOURCE_NAME = ?");
        sb.append("   AND SOURCE_SCHEMA = ?");
        sb.append("   AND SOURCE_VERSION = ?");
        sb.append(" WITH UR");
        SEL_EXP_STATEMENT = sb.toString();
    }

    public DB2PlanInstance(DB2DataSource dataSource, JDBCSession session, ResultSet dbResult, DB2PlanStatement db2PlanStatement) throws SQLException {
        this.db2PlanStatement = db2PlanStatement;
        this.explainRequester = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"EXPLAIN_REQUESTER");
        this.explainTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"EXPLAIN_TIME");
        this.sourceName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_NAME");
        this.sourceSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_SCHEMA");
        this.sourceVersion = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_VERSION");
    }

    public String getStatement_id() {
        return this.statement_id;
    }

    public String getExplainRequester() {
        return this.explainRequester;
    }

    public Timestamp getExplainTime() {
        return this.explainTime;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }
}

