/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class SQLTemplateStore
extends TemplateStore {
    private static final Log log = Log.getLog(SQLTemplateStore.class);
    public static final String PREF_STORE_KEY = "org.jkiss.dbeaver.core.sql_templates";

    public SQLTemplateStore(ContextTypeRegistry registry) {
        super(registry, (IPreferenceStore)new PreferenceStoreDelegate((DBPPreferenceStore)new CustomTemplatesStore()), PREF_STORE_KEY);
    }

    protected void loadContributedTemplates() throws IOException {
        Collection<TemplatePersistenceData> contributed = this.readContributedTemplates();
        for (TemplatePersistenceData data : contributed) {
            this.internalAdd(data);
        }
    }

    private Collection<TemplatePersistenceData> readContributedTemplates() throws IOException {
        ArrayList<TemplatePersistenceData> templates = new ArrayList<TemplatePersistenceData>();
        this.readIncludedTemplates("org.jkiss.dbeaver.ui.editors.sql", templates, "templates/default-templates.xml", "$nl$/templates/default-templates.properties");
        for (DBPDataSourceProviderDescriptor provider : DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders()) {
            this.readIncludedTemplates(provider.getPluginId(), templates, "templates/" + provider.getId() + "-templates.xml", "$nl$/templates/" + provider.getId() + "-templates.properties");
        }
        return templates;
    }

    private void readIncludedTemplates(String contributorId, Collection<TemplatePersistenceData> templates, String file, String translations) throws IOException {
        Bundle plugin;
        URL url;
        if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)contributorId)), (IPath)Path.fromOSString((String)file), null)) != null) {
            URL bundleURL;
            PropertyResourceBundle bundle = null;
            if (translations != null && (bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null)) != null) {
                InputStream bundleStream = bundleURL.openStream();
                try {
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                finally {
                    ContentUtils.close((Closeable)bundleStream);
                }
            }
            BufferedInputStream stream = new BufferedInputStream(url.openStream());
            try {
                TemplatePersistenceData[] datas;
                TemplateReaderWriter reader = new TemplateReaderWriter();
                TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read((InputStream)stream, bundle);
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData data = templatePersistenceDataArray[n2];
                    if (data.isCustom()) {
                        if (data.getId() == null) {
                            log.error((Object)"No template id specified");
                        } else {
                            log.error((Object)("Template " + data.getTemplate().getName() + " deleted"));
                        }
                    } else if (this.validateTemplate(data.getTemplate())) {
                        templates.add(data);
                    }
                    ++n2;
                }
            }
            finally {
                ContentUtils.close((Closeable)stream);
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException e) {
                log.error((Object)("Template '" + template.getName() + "' validation failed"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    protected void handleException(IOException x) {
        log.error((Object)x);
    }

    private static class CustomTemplatesStore
    extends SimplePreferenceStore {
        private CustomTemplatesStore() {
            super(DBWorkbench.getPlatform().getPreferenceStore());
            try {
                java.nio.file.Path configurationFile = this.getConfigurationFile();
                if (Files.exists(configurationFile, new LinkOption[0])) {
                    this.setValue(SQLTemplateStore.PREF_STORE_KEY, Files.readString(configurationFile));
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }

        private java.nio.file.Path getConfigurationFile() {
            return DBWorkbench.getPlatform().getLocalConfigurationFile("templates.xml");
        }

        public void save() throws IOException {
            block13: {
                java.nio.file.Path configurationFile = this.getConfigurationFile();
                String templatesConfig = this.getString(SQLTemplateStore.PREF_STORE_KEY);
                if (!CommonUtils.isEmpty((String)templatesConfig)) {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedWriter writer = Files.newBufferedWriter(configurationFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                        writer.write(templatesConfig);
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (Files.exists(configurationFile, new LinkOption[0])) {
                    try {
                        Files.delete(configurationFile);
                    }
                    catch (IOException e) {
                        log.warn((Object)"Can't delete empty template configuration", (Throwable)e);
                    }
                }
            }
        }
    }
}

