/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.registry.BaseProjectImpl;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.utils.IOUtils;

public class LocalProjectImpl
extends BaseProjectImpl {
    private static final Log log = Log.getLog(LocalProjectImpl.class);
    private static final String EMPTY_PROJECT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n<name>${project-name}</name>\n<comment></comment>\n<projects>\n</projects>\n<buildSpec>\n</buildSpec>\n<natures>\n</natures>\n</projectDescription>";
    @NotNull
    private final IProject project;

    public LocalProjectImpl(@NotNull BaseWorkspaceImpl workspace, @NotNull IProject project, @Nullable SMSessionContext sessionContext) {
        super((DBPWorkspace)workspace, sessionContext);
        this.project = project;
    }

    public boolean isVirtual() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.project.getName();
    }

    @NotNull
    public Path getAbsolutePath() {
        return this.project.getLocation().toFile().toPath();
    }

    @Nullable
    public IProject getEclipseProject() {
        return this.project;
    }

    public boolean isOpen() {
        return this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        block8: {
            if (!this.project.isOpen()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    this.project.open((IProgressMonitor)monitor);
                    this.project.refreshLocal(1, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    if (!this.getWorkspace().getPlatform().getApplication().isStandalone() || !e.getMessage().contains(".project")) break block8;
                    try {
                        this.recoverProjectDescription();
                        this.project.open((IProgressMonitor)monitor);
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Error opening project", (Throwable)e2);
                        return;
                    }
                }
            }
        }
        if (this.isInMemory()) {
            this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
            return;
        }
        Path mdFolder = this.getMetadataFolder(false);
        Path dsConfig = this.getAbsolutePath().resolve(".dbeaver-data-sources.xml");
        if (!Files.exists(mdFolder, new LinkOption[0]) && Files.exists(dsConfig, new LinkOption[0])) {
            this.setFormat(BaseProjectImpl.ProjectFormat.LEGACY);
        } else {
            this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
        }
        this.checkAndUpdateProjectStructure();
        this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.getFormat() == BaseProjectImpl.ProjectFormat.UNKNOWN || this.getFormat() == BaseProjectImpl.ProjectFormat.MODERN) {
            return;
        }
        Path mdConfig = this.getMetadataPath().resolve("project-metadata.json");
        if (!Files.exists(mdConfig, new LinkOption[0])) {
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.setResourceProperties(projectResourceProperties);
            }
            this.flushMetadata();
        }
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        if (!(this.getWorkspace() instanceof DBPWorkspaceEclipse)) {
            return result;
        }
        DBPWorkspaceEclipse workspaceEclipse = (DBPWorkspaceEclipse)this.getWorkspace();
        try {
            BucketTree bucketTree = new BucketTree((Workspace)workspaceEclipse.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    public void recoverProjectDescription() throws IOException {
        Path mdFile = this.getAbsolutePath().resolve(".project");
        log.debug((Object)("Recovering project '" + this.project.getName() + "' metadata " + mdFile.toAbsolutePath()));
        IOUtils.writeFileFromString((File)mdFile.toFile(), (String)EMPTY_PROJECT_TEMPLATE.replace("${project-name}", this.project.getName()));
    }
}

