/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.ui.UIUtils;

public class TaskHandlerDelete
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<Object> objectsToDelete = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
            for (Object element : iStructuredSelection) {
                if (element instanceof DBTTask) {
                    objectsToDelete.add((DBTTask)element);
                    continue;
                }
                if (!(element instanceof DBTTaskFolder)) continue;
                objectsToDelete.add((DBTTaskFolder)element);
            }
        }
        if (!objectsToDelete.isEmpty()) {
            DBPNamedObject dBPNamedObject;
            if (objectsToDelete.size() == 1 ? ((dBPNamedObject = (DBPNamedObject)objectsToDelete.get(0)) instanceof DBTTaskFolder ? this.confirmDeleteObjectAction(event, TaskUIViewMessages.task_handler_delete_folder_error_title, TaskUIViewMessages.task_handler_delete_confirm_question_delete_task_folder, dBPNamedObject) : this.confirmDeleteObjectAction(event, TaskUIViewMessages.task_handler_delete_confirm_title_delete_task, TaskUIViewMessages.task_handler_delete_confirm_question_delete_task, dBPNamedObject)) : !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)TaskUIViewMessages.task_handler_delete_confirm_title_delete_tasks, (String)NLS.bind((String)TaskUIViewMessages.task_handler_delete_confirm_question_delete_tasks, (Object)objectsToDelete.size()))) {
                return null;
            }
            for (DBPNamedObject dBPNamedObject2 : objectsToDelete) {
                try {
                    if (dBPNamedObject2 instanceof DBTTask) {
                        DBTTask task = (DBTTask)dBPNamedObject2;
                        task.getProject().getTaskManager().deleteTaskConfiguration(task);
                        continue;
                    }
                    DBTTaskFolder taskFolder = (DBTTaskFolder)dBPNamedObject2;
                    taskFolder.getProject().getTaskManager().removeTaskFolder(taskFolder);
                }
                catch (DBException e) {
                    if (dBPNamedObject2 instanceof DBTTask) {
                        DBWorkbench.getPlatformUI().showError(TaskUIViewMessages.task_handler_delete_error_deleting_task_from_scheduler_title, NLS.bind((String)TaskUIViewMessages.task_handler_delete_error_deleting_task_from_scheduler_message, (Object)((DBTTask)dBPNamedObject2).getId()), (Throwable)e);
                        continue;
                    }
                    DBWorkbench.getPlatformUI().showError(TaskUIViewMessages.task_handler_delete_folder_error_title, NLS.bind((String)TaskUIViewMessages.task_handler_delete_folder_error_message, (Object)dBPNamedObject2.getName()), (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean confirmDeleteObjectAction(ExecutionEvent event, String title, String message, DBPNamedObject namedObject) {
        return !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)NLS.bind((String)message, (Object)namedObject.getName()));
    }
}

