/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.CommonUtils;

public class GlobalPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.global";
    public static final String PROP_STANDALONE = "standalone";
    public static final String PROP_DISTRIBUTED = "distributed";
    public static final String PROP_BUNDLE_INSTALLED = "bundleInstalled";
    public static final String PROP_HAS_PERMISSION = "hasPermission";
    public static final String PROP_CAN_CREATE_CONNECTION = "canCreateConnection";
    public static final String PROP_HAS_ACTIVE_PROJECT = "hasActiveProject";
    public static final String PROP_HAS_MULTI_PROJECTS = "hasMultipleProjects";
    public static final String PROP_CAN_CREATE_PROJECT = "canCreateProject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        switch (property) {
            case "hasPermission": {
                return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission(CommonUtils.toString((Object)expectedValue));
            }
            case "hasMultipleProjects": {
                return DBWorkbench.getPlatform().getWorkspace().getProjects().size() > 1;
            }
            case "hasActiveProject": {
                return DBWorkbench.getPlatform().getWorkspace().getActiveProject() != null;
            }
            case "standalone": {
                return DBWorkbench.getPlatform().getApplication().isStandalone();
            }
            case "distributed": {
                return DBWorkbench.getPlatform().getApplication().isDistributed();
            }
            case "bundleInstalled": {
                return Platform.getBundle((String)((String)args[0])) != null;
            }
            case "canCreateProject": {
                return !DBWorkbench.getPlatform().getApplication().isDistributed();
            }
            case "canCreateConnection": {
                for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
                    if (!project.hasRealmPermission("project-datasource-edit")) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.global." + propName));
    }

    public static class ResourceListener
    implements IPluginService,
    IResourceChangeListener {
        public void activateService() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public void deactivateService() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    if (childDelta.getResource() instanceof IProject && (childDelta.getKind() == 1 || childDelta.getKind() == 2)) {
                        GlobalPropertyTester.firePropertyChange(GlobalPropertyTester.PROP_HAS_MULTI_PROJECTS);
                    }
                    ++n2;
                }
            }
        }
    }
}

