/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTableIndex<CONTAINER extends DBSObjectContainer, TABLE extends JDBCTable>
extends AbstractTableIndex
implements DBPSaveableObject {
    private final CONTAINER container;
    private final TABLE table;
    protected String name;
    protected DBSIndexType indexType;
    private boolean persisted;

    protected JDBCTableIndex(CONTAINER container, TABLE table, String name, @Nullable DBSIndexType indexType, boolean persisted) {
        this.container = container;
        this.table = table;
        this.name = name;
        this.indexType = indexType;
        this.persisted = persisted;
    }

    protected JDBCTableIndex(CONTAINER container, TABLE table, DBSTableIndex source, boolean persisted) {
        this.container = container;
        this.table = table;
        this.name = source.getName();
        this.indexType = source.getIndexType();
        this.persisted = persisted;
    }

    protected JDBCTableIndex(JDBCTableIndex<CONTAINER, TABLE> source) {
        this.container = source.container;
        this.table = source.table;
        this.name = source.name;
        this.indexType = source.indexType;
        this.persisted = source.persisted;
    }

    public CONTAINER getContainer() {
        return this.container;
    }

    @NotNull
    public TABLE getParentObject() {
        return this.table;
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String indexName) {
        this.name = indexName;
    }

    @Property(viewable=true, order=1)
    public String getTableColumn(@NotNull DBRProgressMonitor monitor) throws DBException {
        return CommonUtils.safeList(this.getAttributeReferences(monitor)).stream().map(DBPNamedObject::getName).collect(Collectors.joining(", "));
    }

    @Property(viewable=true, order=2)
    public TABLE getTable() {
        return this.table;
    }

    @Override
    @Property(viewable=true, order=3)
    public DBSIndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(DBSIndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }
}

