/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBXTreeFolder
extends DBXTreeNode {
    private String type;
    private String label;
    private String description;
    private String optionalItem;
    private boolean isOptional;
    private List<String> contributedCategories = null;
    private ItemType[] itemTypes = null;

    public DBXTreeFolder(AbstractDescriptor source, DBXTreeNode parent, IConfigurationElement config, String type, boolean navigable, boolean virtual, String visibleIf, boolean isOptional) {
        super(source, parent, config, navigable, false, virtual, false, visibleIf, null);
        this.type = type;
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.optionalItem = config.getAttribute("optionalItem");
        this.isOptional = isOptional;
        Object[] itemTypesConfig = config.getChildren("itemType");
        if (!ArrayUtils.isEmpty((Object[])itemTypesConfig)) {
            ArrayList<ItemType> objectCreateTypes = null;
            Object[] objectArray = itemTypesConfig;
            int n = itemTypesConfig.length;
            int n2 = 0;
            while (n2 < n) {
                Object it = objectArray[n2];
                String itemTypeName = it.getAttribute("type");
                if (!CommonUtils.isEmpty((String)itemTypeName)) {
                    if (objectCreateTypes == null) {
                        objectCreateTypes = new ArrayList<ItemType>();
                    }
                    objectCreateTypes.add(new ItemType(itemTypeName, it.getAttribute("label"), source.iconToImage(it.getAttribute("icon"))));
                }
                ++n2;
            }
            if (objectCreateTypes != null) {
                this.itemTypes = objectCreateTypes.toArray(new ItemType[0]);
            }
        }
    }

    DBXTreeFolder(AbstractDescriptor source, DBXTreeNode parent, DBXTreeFolder folder) {
        super(source, parent, folder);
        this.type = folder.type;
        this.label = folder.label;
        this.description = folder.description;
        this.optionalItem = folder.optionalItem;
        this.isOptional = folder.isOptional;
        this.contributedCategories = folder.contributedCategories == null ? null : new ArrayList<String>(folder.contributedCategories);
        this.itemTypes = folder.itemTypes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIdOrType() {
        String id = this.getId();
        return !CommonUtils.isEmpty((String)id) ? id : this.type;
    }

    public String getOptionalItem() {
        return this.optionalItem;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public String getNodeTypeLabel(@Nullable DBPDataSource dataSource, @Nullable String locale) {
        if (locale == null) {
            return this.label;
        }
        return this.getConfig().getAttribute("label", locale);
    }

    @Override
    public String getChildrenTypeLabel(@Nullable DBPDataSource dataSource, String locale) {
        return this.getNodeTypeLabel(dataSource, locale);
    }

    @Override
    public boolean hasChildren(DBNNode context, boolean navigable) {
        boolean hasChildren = super.hasChildren(context, navigable);
        if (!hasChildren) {
            hasChildren = !CommonUtils.isEmpty(this.contributedCategories);
        }
        return hasChildren;
    }

    @Override
    @NotNull
    public List<DBXTreeNode> getChildren(DBNNode context) {
        List<DBXTreeNode> children = super.getChildren(context);
        if (!CommonUtils.isEmpty(this.contributedCategories) && context instanceof DBNDatabaseNode) {
            ArrayList<DBXTreeNode> childrenWithContributions = new ArrayList<DBXTreeNode>(children);
            DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
            DBPDataSourceContainer dataSource = ((DBNDatabaseNode)context).getDataSourceContainer();
            for (String category : this.contributedCategories) {
                DBPEditorContribution[] editors;
                DBPEditorContribution[] dBPEditorContributionArray = editors = dspRegistry.getContributedEditors(category, dataSource);
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPEditorContribution editor = dBPEditorContributionArray[n2];
                    if (editor.isVisible(context)) {
                        DBXTreeObject editorNode = new DBXTreeObject(this.getSource(), null, null, null, editor.getLabel(), editor.getDescription(), editor.getEditorId());
                        editorNode.setDefaultIcon(editor.getIcon());
                        childrenWithContributions.add(editorNode);
                    }
                    ++n2;
                }
            }
            return childrenWithContributions;
        }
        return children;
    }

    public DBXTreeItem getChildByPath(String path) {
        for (DBXTreeNode node : this.getChildren()) {
            if (!(node instanceof DBXTreeItem) || !path.equals(((DBXTreeItem)node).getPath())) continue;
            return (DBXTreeItem)node;
        }
        return null;
    }

    @Override
    protected boolean isVisible(DBNNode context) {
        if (!super.isVisible(context)) {
            return false;
        }
        for (DBXTreeNode childNode : this.getChildren(context)) {
            if (!childNode.isVisible(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Folder " + this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getContributedCategories() {
        return CommonUtils.safeList(this.contributedCategories);
    }

    public void addContribution(String category) {
        if (this.contributedCategories == null) {
            this.contributedCategories = new ArrayList<String>();
        }
        this.contributedCategories.add(category);
    }

    public ItemType[] getItemTypes() {
        return this.itemTypes;
    }

    public static class ItemType {
        private String className;
        private String itemType;
        private DBPImage itemIcon;

        private ItemType(String className, String itemType, DBPImage itemIcon) {
            this.className = className;
            this.itemType = itemType;
            this.itemIcon = itemIcon;
        }

        public String getClassName() {
            return this.className;
        }

        public String getItemType() {
            return this.itemType;
        }

        public DBPImage getItemIcon() {
            return this.itemIcon;
        }
    }
}

