/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AbstractBorder;
import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LabeledBorder;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class AbstractLabeledBorder
extends AbstractBorder
implements LabeledBorder {
    private Dimension textExtents;
    private String label;
    private Insets insets;
    private Color textColor = ColorConstants.black;
    private Font font;

    public AbstractLabeledBorder() {
        String className = this.getClass().getName();
        this.setLabel(className.substring(className.lastIndexOf(46) + 1, className.length()));
    }

    public AbstractLabeledBorder(String s) {
        this.setLabel(s);
    }

    protected abstract Insets calculateInsets(IFigure var1);

    protected Font getFont(IFigure f) {
        if (this.font == null) {
            return f.getFont();
        }
        return this.font;
    }

    @Override
    public Insets getInsets(IFigure fig) {
        if (this.insets == null) {
            this.insets = this.calculateInsets(fig);
        }
        return this.insets;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Dimension getPreferredSize(IFigure fig) {
        return new Dimension(this.getTextExtents(fig));
    }

    public Color getTextColor() {
        return this.textColor;
    }

    protected Dimension getTextExtents(IFigure f) {
        if (this.textExtents == null) {
            this.textExtents = FigureUtilities.getTextExtents(this.label, this.getFont(f));
        }
        return this.textExtents;
    }

    protected void invalidate() {
        this.insets = null;
        this.textExtents = null;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    @Override
    public void setLabel(String s) {
        this.label = s == null ? "" : s;
        this.invalidate();
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }
}

