/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar.nfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.parser.common.TermPatternInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;

public class GrammarNfaState {
    private final int id;
    private final GrammarRule rule;
    private final ArrayList<GrammarNfaTransition> next;
    private HashMap<TermPatternInfo, ArrayList<GrammarNfaTransition>> nextByTerm = null;
    private TermGroup eofGroup = null;
    private LinkedHashMap<String, TermGroup> termGroupByName = null;
    private Pattern pattern = null;

    public GrammarNfaState(int id, GrammarRule rule) {
        this.id = id;
        this.rule = rule;
        this.next = new ArrayList();
    }

    public String toString() {
        return "GrammarNfaState#" + this.id;
    }

    public int getId() {
        return this.id;
    }

    public GrammarRule getRule() {
        return this.rule;
    }

    public List<GrammarNfaTransition> getNext() {
        return this.next;
    }

    public void remove(GrammarNfaTransition t) {
        this.next.remove(t);
    }

    public void registerExpectedTerm(TermPatternInfo p, GrammarNfaTransition t) {
        ArrayList tt;
        if (this.nextByTerm == null) {
            this.nextByTerm = new HashMap();
        }
        if (!(tt = this.nextByTerm.computeIfAbsent(p, k -> new ArrayList())).contains(t)) {
            tt.add(t);
            tt.trimToSize();
        }
    }

    public Set<TermPatternInfo> getExpectedTerms() {
        return this.nextByTerm == null ? Collections.emptySet() : Collections.unmodifiableSet(this.nextByTerm.keySet());
    }

    public int getExpectedTermsCount() {
        return this.nextByTerm.size();
    }

    public boolean isExpectedTermsPopulated() {
        return this.nextByTerm != null;
    }

    public Map<TermPatternInfo, List<GrammarNfaTransition>> getAllNextByTerms() {
        return Collections.unmodifiableMap(this.nextByTerm);
    }

    public Iterable<GrammarNfaTransition> getNextByTerm(TermPatternInfo term) {
        ArrayList<GrammarNfaTransition> transitions;
        if (this.nextByTerm != null && (transitions = this.nextByTerm.get(term)) != null) {
            return transitions;
        }
        return Collections.emptyList();
    }

    public void compact() {
        this.next.trimToSize();
        if (this.nextByTerm != null) {
            for (ArrayList<GrammarNfaTransition> tt : this.nextByTerm.values()) {
                tt.trimToSize();
            }
        }
    }

    public void prepare() {
        ArrayList<TermPatternInfo> parts = new ArrayList<TermPatternInfo>(this.nextByTerm.size());
        this.termGroupByName = new LinkedHashMap();
        for (Map.Entry<TermPatternInfo, ArrayList<GrammarNfaTransition>> step : this.nextByTerm.entrySet()) {
            String groupName = step.getKey().makeRegexGroupName();
            TermGroup termGroup = new TermGroup(groupName, step.getKey(), step.getValue());
            if (step.getKey().isEOF()) {
                this.eofGroup = termGroup;
                continue;
            }
            parts.add(step.getKey());
            this.termGroupByName.put(groupName, termGroup);
        }
        parts.sort(Comparator.comparingInt(a -> a.caps.priority));
        this.pattern = Pattern.compile("(" + parts.stream().map(TermPatternInfo::makeRegexGroup).collect(Collectors.joining("|")) + ")");
    }

    public DispatchResult dispatch(String text, int position) {
        if (this.pattern == null) {
            throw new IllegalStateException();
        }
        if (position >= text.length()) {
            if (this.eofGroup != null) {
                return new DispatchResult(this.eofGroup.term, position, this.eofGroup.transitions);
            }
        } else {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.find(position)) {
                for (TermGroup g : this.termGroupByName.values()) {
                    int end = matcher.end(g.groupName);
                    if (end <= 0 || end - position <= 0 || matcher.start(g.groupName) != position) continue;
                    return new DispatchResult(g.term, end, g.transitions);
                }
            }
        }
        return null;
    }

    public static class DispatchResult {
        public final TermPatternInfo term;
        public final int end;
        public final List<GrammarNfaTransition> transitions;

        public DispatchResult(TermPatternInfo term, int end, ArrayList<GrammarNfaTransition> transitions) {
            this.term = term;
            this.end = end;
            this.transitions = Collections.unmodifiableList(transitions);
        }
    }

    private static class TermGroup {
        private final String groupName;
        private final TermPatternInfo term;
        private final ArrayList<GrammarNfaTransition> transitions;

        public TermGroup(String groupName, TermPatternInfo term, ArrayList<GrammarNfaTransition> transitions) {
            this.groupName = groupName;
            this.term = term;
            this.transitions = transitions;
            this.transitions.trimToSize();
        }
    }
}

