/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Locale;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageTransactions
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.transactions";
    private Button smartCommitCheck;
    private Button smartCommitRecoverCheck;
    private Button autoCloseTransactionsCheck;
    private Text autoCloseTransactionsTtlText;
    private Button showTransactionNotificationsCheck;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("transaction.smart.commit") || store.contains("transaction.smart.commit.recover") || store.contains("transaction.auto.close.enabled") || store.contains("transaction.auto.close.ttl") || store.contains("transaction.show.notifications");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group txnNameGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_connection_edit_wizard_transactions, (int)2, (int)768, (int)0);
        this.smartCommitCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_smart_auto_commit, (String)CoreMessages.action_menu_transaction_smart_auto_commit_tip, (boolean)false, (int)2);
        this.smartCommitRecoverCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover_tip, (boolean)false, (int)2);
        this.autoCloseTransactionsCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_auto_close_enabled, (String)CoreMessages.action_menu_transaction_auto_close_enabled_tip, (boolean)false, (int)1);
        this.autoCloseTransactionsTtlText = new Text((Composite)txnNameGroup, 2048);
        this.autoCloseTransactionsTtlText.setToolTipText(CoreMessages.action_menu_transaction_auto_close_ttl_tip);
        this.autoCloseTransactionsTtlText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        GridData gd = new GridData();
        gd.widthHint = UIUtils.getFontHeight((Control)this.autoCloseTransactionsTtlText) * 6;
        this.autoCloseTransactionsTtlText.setLayoutData((Object)gd);
        Group notifyNameGroup = UIUtils.createControlGroup((Composite)composite, (String)"Notifications", (int)2, (int)768, (int)0);
        this.showTransactionNotificationsCheck = UIUtils.createCheckbox((Composite)notifyNameGroup, (String)"Show transaction end notification", (String)"Show transaction end (commit or rollback) notification in task bar", (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.smartCommitCheck.setSelection(store.getBoolean("transaction.smart.commit"));
            this.smartCommitRecoverCheck.setSelection(store.getBoolean("transaction.smart.commit.recover"));
            this.autoCloseTransactionsCheck.setSelection(store.getBoolean("transaction.auto.close.enabled"));
            this.autoCloseTransactionsTtlText.setText(store.getString("transaction.auto.close.ttl"));
            this.showTransactionNotificationsCheck.setSelection(store.getBoolean("transaction.show.notifications"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("transaction.smart.commit", this.smartCommitCheck.getSelection());
            store.setValue("transaction.smart.commit.recover", this.smartCommitRecoverCheck.getSelection());
            store.setValue("transaction.auto.close.enabled", this.autoCloseTransactionsCheck.getSelection());
            store.setValue("transaction.auto.close.ttl", this.autoCloseTransactionsTtlText.getText());
            store.setValue("transaction.show.notifications", this.showTransactionNotificationsCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("transaction.smart.commit");
        store.setToDefault("transaction.smart.commit.recover");
        store.setToDefault("transaction.auto.close.enabled");
        store.setToDefault("transaction.auto.close.ttl");
        store.setToDefault("transaction.show.notifications");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

