/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.internal.GEFMessages;
import org.eclipse.gef3.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef3.palette.PaletteTemplateEntry;
import org.eclipse.gef3.ui.actions.Clipboard;
import org.eclipse.gef3.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class CopyTemplateAction
extends WorkbenchPartAction
implements ISelectionChangedListener {
    private Object template;

    public CopyTemplateAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.COPY.getId());
        this.setText(GEFMessages.CopyAction_Label);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.template != null;
    }

    @Override
    public void dispose() {
        this.template = null;
    }

    public void run() {
        Clipboard.getDefault().setContents(this.template);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj;
        ISelection s = event.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        this.template = null;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) instanceof EditPart) {
            Object model = ((EditPart)obj).getModel();
            if (model instanceof CombinedTemplateCreationEntry) {
                this.template = ((CombinedTemplateCreationEntry)model).getTemplate();
            } else if (model instanceof PaletteTemplateEntry) {
                this.template = ((PaletteTemplateEntry)model).getTemplate();
            }
        }
        this.refresh();
    }
}

