/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.edit.OracleTableColumnManager;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleMaterializedView;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class OracleMaterializedViewManager
extends SQLObjectEditor<OracleMaterializedView, OracleSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((OracleMaterializedView)command.getObject()).getName())) {
            throw new DBException("View name cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleMaterializedView> getObjectsCache(OracleMaterializedView object) {
        return object.getSchema().tableCache;
    }

    protected OracleMaterializedView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        OracleSchema schema = (OracleSchema)container;
        OracleMaterializedView newView = new OracleMaterializedView(schema, "NEW_MVIEW");
        this.setNewObjectName(monitor, schema, newView);
        newView.setObjectDefinitionText("SELECT 1 FROM DUAL");
        newView.setCurrentDDLFormat(OracleDDLFormat.COMPACT);
        return newView;
    }

    protected String getBaseObjectName() {
        return "NewMView";
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actions, (DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler>)command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actionList, (DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler>)command, options);
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP MATERIALIZED VIEW " + ((OracleMaterializedView)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceViewQuery(DBRProgressMonitor monitor, List<DBEPersistAction> actions, DBECommandComposite<OracleMaterializedView, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        OracleMaterializedView view = (OracleMaterializedView)command.getObject();
        StringBuilder decl = new StringBuilder(200);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        boolean hasComment = command.hasProperty((Object)"comment");
        if (!hasComment || command.getProperties().size() > 1) {
            List sqlScriptElements;
            String mViewDefinition = view.getMViewText().trim();
            if (mViewDefinition.contains("CREATE MATERIALIZED VIEW")) {
                if (mViewDefinition.endsWith(";")) {
                    mViewDefinition = mViewDefinition.substring(0, mViewDefinition.length() - 1);
                }
                decl.append(mViewDefinition);
            } else {
                decl.append("CREATE MATERIALIZED VIEW ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(lineSeparator).append("AS ").append(mViewDefinition);
            }
            if (view.isPersisted()) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP MATERIALIZED VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            }
            if ((sqlScriptElements = SQLScriptParser.parseScript((DBPDataSource)view.getDataSource(), (String)mViewDefinition)).size() > 1) {
                for (SQLScriptElement scriptElement : sqlScriptElements) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view part", scriptElement.getText()));
                }
                return;
            }
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", decl.toString()));
        }
        if (hasComment || CommonUtils.getOption(options, (String)"object.save") && CommonUtils.isNotEmpty((String)view.getComment())) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment view", "COMMENT ON MATERIALIZED VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBPDataSource)view.getDataSource(), (String)CommonUtils.notEmpty((String)view.getComment()))));
        }
        if ((!hasComment || command.getProperties().size() != 1) && CommonUtils.getOption(options, (String)"object.save")) {
            for (OracleTableColumn column : CommonUtils.safeCollection(view.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getComment(monitor))) continue;
                OracleTableColumnManager.addColumnCommentAction(actions, (DBSEntityAttribute)column, (DBSEntity)view);
            }
        }
    }
}

