/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContextListener;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.impl.OutputWriterAdapter;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLVariablesRegistry;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLScriptContext
implements DBCScriptContext {
    private final Map<String, DBCScriptContext.VariableInfo> variables = new LinkedHashMap<String, DBCScriptContext.VariableInfo>();
    private final Map<String, Object> defaultParameters = new HashMap<String, Object>();
    private final Map<String, Map<String, Object>> pragmas = new HashMap<String, Map<String, Object>>();
    private DBCScriptContextListener[] listeners = null;
    private final Map<String, Object> data = new HashMap<String, Object>();
    @Nullable
    private final SQLScriptContext parentContext;
    @NotNull
    private final DBPContextProvider contextProvider;
    @Nullable
    private final Path sourceFile;
    @NotNull
    private final DBCOutputWriter outputWriter;
    private final SQLParametersProvider parametersProvider;
    private boolean ignoreParameters;

    public SQLScriptContext(@Nullable SQLScriptContext parentContext, @NotNull DBPContextProvider contextProvider, @Nullable Path sourceFile, @NotNull Writer outputWriter, @Nullable SQLParametersProvider parametersProvider) {
        this(parentContext, contextProvider, sourceFile, (DBCOutputWriter)new OutputWriterAdapter(new PrintWriter(outputWriter)), parametersProvider);
    }

    public SQLScriptContext(@Nullable SQLScriptContext parentContext, @NotNull DBPContextProvider contextProvider, @Nullable Path sourceFile, @NotNull DBCOutputWriter outputWriter, @Nullable SQLParametersProvider parametersProvider) {
        this.parentContext = parentContext;
        this.contextProvider = contextProvider;
        this.sourceFile = sourceFile;
        this.outputWriter = outputWriter;
        this.parametersProvider = parametersProvider;
    }

    @Nullable
    public SQLScriptContext getParentContext() {
        return this.parentContext;
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.contextProvider.getExecutionContext();
    }

    @Nullable
    public Path getSourceFile() {
        return this.sourceFile;
    }

    public boolean hasVariable(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        return this.parentContext != null && this.parentContext.hasVariable(name);
    }

    public boolean hasDefaultParameterValue(String name) {
        if (this.defaultParameters.containsKey(name)) {
            return true;
        }
        return this.parentContext != null && this.parentContext.hasDefaultParameterValue(name);
    }

    public Object getVariable(String name) {
        DBCScriptContext.VariableInfo variableInfo = this.variables.get(name);
        if (variableInfo == null && this.parentContext != null) {
            return this.parentContext.getVariable(name);
        }
        return variableInfo == null ? null : variableInfo.value;
    }

    public void setVariable(String name, Object value) {
        DBCScriptContext.VariableInfo v = new DBCScriptContext.VariableInfo(name, value, DBCScriptContext.VariableType.VARIABLE);
        DBCScriptContext.VariableInfo ov = this.variables.put(name, v);
        this.notifyListeners(ov == null ? DBCScriptContextListener.ContextAction.ADD : DBCScriptContextListener.ContextAction.UPDATE, v);
        if (this.parentContext != null) {
            this.parentContext.setVariable(name, value);
        }
    }

    public void removeVariable(String name) {
        DBCScriptContext.VariableInfo v = this.variables.remove(name);
        if (v != null) {
            this.notifyListeners(DBCScriptContextListener.ContextAction.DELETE, v);
        }
        if (this.parentContext != null) {
            this.parentContext.removeVariable(name);
        }
    }

    public void removeDefaultParameterValue(String name) {
        SQLQueryParameterRegistry instance = SQLQueryParameterRegistry.getInstance();
        Object p = this.defaultParameters.remove(name);
        instance.deleteParameter(name);
        instance.save();
        this.notifyListeners(DBCScriptContextListener.ContextAction.DELETE, name, p);
        if (this.parentContext != null) {
            this.parentContext.removeDefaultParameterValue(name);
        }
    }

    public List<DBCScriptContext.VariableInfo> getVariables() {
        return new ArrayList<DBCScriptContext.VariableInfo>(this.variables.values());
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables.clear();
        for (Map.Entry<String, Object> ve : variables.entrySet()) {
            DBCScriptContext.VariableInfo v = new DBCScriptContext.VariableInfo(ve.getKey(), ve.getValue(), DBCScriptContext.VariableType.VARIABLE);
            DBCScriptContext.VariableInfo ov = this.variables.put(ve.getKey(), v);
            this.notifyListeners(ov == null ? DBCScriptContextListener.ContextAction.ADD : DBCScriptContextListener.ContextAction.UPDATE, v);
        }
        if (this.parentContext != null) {
            this.parentContext.setVariables(variables);
        }
    }

    public Object getParameterDefaultValue(String name) {
        return this.defaultParameters.get(name);
    }

    public void setParameterDefaultValue(String name, Object value) {
        Object op = this.defaultParameters.put(name, value);
        this.notifyListeners(op == null ? DBCScriptContextListener.ContextAction.ADD : DBCScriptContextListener.ContextAction.UPDATE, name, value);
        if (this.parentContext != null) {
            this.parentContext.setParameterDefaultValue(name, value);
        }
    }

    @NotNull
    public Map<String, Map<String, Object>> getPragmas() {
        if (this.parentContext != null) {
            return this.parentContext.getPragmas();
        }
        return this.pragmas;
    }

    public void setPragma(@NotNull String id, @Nullable Map<String, Object> params) {
        if (this.parentContext != null) {
            this.parentContext.setPragma(id, params);
        } else {
            this.pragmas.put(id, params);
        }
    }

    public <T> T getData(String key) {
        return (T)this.data.get(key);
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    @NotNull
    public DBCOutputWriter getOutputWriter() {
        return this.outputWriter;
    }

    public void clearStatementContext() {
        this.pragmas.clear();
    }

    public boolean isIgnoreParameters() {
        return this.ignoreParameters;
    }

    public void setIgnoreParameters(boolean ignoreParameters) {
        this.ignoreParameters = ignoreParameters;
    }

    public boolean executeControlCommand(SQLControlCommand command) throws DBException {
        if (command.isEmptyCommand()) {
            return true;
        }
        SQLCommandHandlerDescriptor commandHandler = SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId());
        if (commandHandler == null) {
            throw new DBException("Command '" + command.getCommand() + "' not supported");
        }
        return commandHandler.createHandler().handleCommand(command, this);
    }

    public void copyFrom(SQLScriptContext context) {
        this.variables.clear();
        this.variables.putAll(context.variables);
        this.data.clear();
        this.data.putAll(context.data);
        this.pragmas.clear();
        this.pragmas.putAll(context.pragmas);
    }

    public boolean fillQueryParameters(SQLQuery query, boolean useDefaults) {
        if (this.ignoreParameters) {
            return true;
        }
        List parameters = query.getParameters();
        if (CommonUtils.isEmpty((Collection)parameters)) {
            return true;
        }
        if (this.parametersProvider != null) {
            Boolean paramsResult = this.parametersProvider.prepareStatementParameters(this, query, parameters, useDefaults);
            if (paramsResult == null) {
                this.ignoreParameters = true;
                return true;
            }
            if (!paramsResult.booleanValue()) {
                return false;
            }
        } else {
            for (SQLQueryParameter parameter : parameters) {
                Object varValue = this.variables.get(parameter.getVarName());
                if (varValue == null) {
                    varValue = this.variables.get(parameter.getName());
                }
                if ((varValue = varValue == null ? this.defaultParameters.get(parameter.getName()) : varValue.value) == null) continue;
                parameter.setValue(CommonUtils.toString((Object)varValue));
            }
        }
        SQLUtils.fillQueryParameters((SQLQuery)query, (List)parameters);
        return true;
    }

    public Map<String, Object> getAllParameters() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(this.defaultParameters.size() + this.variables.size());
        params.putAll(this.defaultParameters);
        for (Map.Entry<String, DBCScriptContext.VariableInfo> v : this.variables.entrySet()) {
            params.put(v.getKey(), v.getValue().value);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVariables(DBPDriver driver, DBPDataSourceContainer dataSource) {
        Map<String, DBCScriptContext.VariableInfo> map = this.variables;
        synchronized (map) {
            this.variables.clear();
            List<DBCScriptContext.VariableInfo> varList = dataSource != null ? SQLVariablesRegistry.getInstance().getDataSourceVariables(dataSource) : (driver != null ? SQLVariablesRegistry.getInstance().getDriverVariables(driver) : new ArrayList<DBCScriptContext.VariableInfo>());
            for (DBCScriptContext.VariableInfo v : varList) {
                this.variables.put(v.name, v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVariables(DBPDriver driver, DBPDataSourceContainer dataSource) {
        ArrayList<DBCScriptContext.VariableInfo> vCopy;
        Map<String, DBCScriptContext.VariableInfo> map = this.variables;
        synchronized (map) {
            vCopy = new ArrayList<DBCScriptContext.VariableInfo>(this.variables.values());
        }
        SQLVariablesRegistry.getInstance().updateVariables(driver, dataSource, vCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVariables() {
        Map<String, DBCScriptContext.VariableInfo> map = this.variables;
        synchronized (map) {
            this.variables.clear();
        }
    }

    public synchronized void addListener(DBCScriptContextListener listener) {
        this.listeners = this.listeners == null ? new DBCScriptContextListener[]{listener} : (DBCScriptContextListener[])ArrayUtils.add(DBCScriptContextListener.class, (Object[])this.listeners, (Object)listener);
    }

    public synchronized void removeListener(DBCScriptContextListener listener) {
        if (this.listeners != null) {
            this.listeners = (DBCScriptContextListener[])ArrayUtils.remove(DBCScriptContextListener.class, (Object[])this.listeners, (Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DBCScriptContextListener[] getListenersCopy() {
        SQLScriptContext sQLScriptContext = this;
        synchronized (sQLScriptContext) {
            if (this.listeners != null) {
                return Arrays.copyOf(this.listeners, this.listeners.length);
            }
        }
        return null;
    }

    private void notifyListeners(DBCScriptContextListener.ContextAction contextAction, DBCScriptContext.VariableInfo variableInfo) {
        DBCScriptContextListener[] lc = this.getListenersCopy();
        if (lc != null) {
            DBCScriptContextListener[] dBCScriptContextListenerArray = lc;
            int n = lc.length;
            int n2 = 0;
            while (n2 < n) {
                DBCScriptContextListener l = dBCScriptContextListenerArray[n2];
                l.variableChanged(contextAction, variableInfo);
                ++n2;
            }
        }
    }

    private void notifyListeners(DBCScriptContextListener.ContextAction contextAction, String paramName, Object paramValue) {
        DBCScriptContextListener[] lc = this.getListenersCopy();
        if (lc != null) {
            DBCScriptContextListener[] dBCScriptContextListenerArray = lc;
            int n = lc.length;
            int n2 = 0;
            while (n2 < n) {
                DBCScriptContextListener l = dBCScriptContextListenerArray[n2];
                l.parameterChanged(contextAction, paramName, paramValue);
                ++n2;
            }
        }
    }
}

