/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLParameterToken;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class ScriptParameterRule
implements TPRule {
    private final SQLSyntaxManager syntaxManager;
    private final SQLParameterToken parameterToken;
    private final StringBuilder buffer;
    private final char anonymousParameterMark;
    private final String namedParameterPrefix;
    private final String[][] quoteStrings;

    public ScriptParameterRule(SQLSyntaxManager syntaxManager, SQLParameterToken parameterToken, String prefix) {
        this.syntaxManager = syntaxManager;
        this.parameterToken = parameterToken;
        this.buffer = new StringBuilder();
        this.anonymousParameterMark = syntaxManager.getAnonymousParameterMark();
        this.namedParameterPrefix = prefix;
        this.quoteStrings = syntaxManager.getIdentifierQuoteStrings();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        block12: {
            block11: {
                block10: {
                    scanner.unread();
                    prevChar = scanner.read();
                    namedPrefix = this.namedParameterPrefix.charAt(0);
                    if (Character.isJavaIdentifierPart(prevChar) || prevChar == namedPrefix || prevChar == this.anonymousParameterMark || prevChar == 92 || prevChar == 47 || prevChar == 91 && namedPrefix == ':') {
                        return TPTokenAbstract.UNDEFINED;
                    }
                    c = scanner.read();
                    if (c == -1 || c != this.anonymousParameterMark && c != namedPrefix) break block11;
                    this.buffer.setLength(0);
                    this.buffer.append((char)c);
                    c = scanner.read();
                    if (!ScriptParameterRule.isIdentifierQuote((char)c, true, false, this.quoteStrings)) ** GOTO lbl27
                    do {
                        this.buffer.append((char)c);
                        c = scanner.read();
                        if (!ScriptParameterRule.isIdentifierQuote((char)c, false, true, this.quoteStrings)) continue;
                        this.buffer.append((char)c);
                        c = scanner.read();
                        break block10;
                    } while (c != -1);
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        this.buffer.append((char)c);
                        c = scanner.read();
lbl27:
                        // 2 sources

                        ** while (c != -1 && Character.isJavaIdentifierPart((int)c))
                    }
                }
                scanner.unread();
                if (this.syntaxManager.isAnonymousParametersEnabled() && this.buffer.length() == 1 && this.buffer.charAt(0) == this.anonymousParameterMark) {
                    return this.parameterToken;
                }
                if (this.syntaxManager.isParametersEnabled() && this.buffer.charAt(0) == namedPrefix && this.buffer.length() > 1) {
                    if (ScriptParameterRule.isIdentifierQuote(this.buffer.charAt(1), true, false, this.quoteStrings) && ScriptParameterRule.isIdentifierQuote(this.buffer.charAt(this.buffer.length() - 1), false, true, this.quoteStrings) && this.buffer.length() > 3) {
                        return this.parameterToken;
                    }
                    validChars = true;
                    i = 1;
                    while (i < this.buffer.length()) {
                        if (!Character.isJavaIdentifierPart(this.buffer.charAt(i))) {
                            validChars = false;
                            break;
                        }
                        ++i;
                    }
                    if (validChars) {
                        return this.parameterToken;
                    }
                }
                i = this.buffer.length() - 1;
                while (i >= 0) {
                    scanner.unread();
                    --i;
                }
                break block12;
            }
            scanner.unread();
        }
        return TPTokenAbstract.UNDEFINED;
    }

    public static int tryConsumeParameterName(@NotNull SQLDialect sqlDialect, @NotNull CharSequence buffer, int position) {
        int endPos = ScriptParameterRule.tryConsumeParameterNameImpl(sqlDialect, buffer, position);
        return endPos > position ? endPos : -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int tryConsumeParameterNameImpl(@NotNull SQLDialect sqlDialect, @NotNull CharSequence buffer, int position) {
        block2: {
            quoteStrings = sqlDialect.getIdentifierQuoteStrings();
            c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
            ++position;
            if (!ScriptParameterRule.isIdentifierQuote((char)c, true, false, quoteStrings)) ** GOTO lbl16
            do {
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
                if (!ScriptParameterRule.isIdentifierQuote((char)c, false, true, quoteStrings)) continue;
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
                break block2;
            } while (c != -1);
            break block2;
lbl-1000:
            // 1 sources

            {
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
lbl16:
                // 2 sources

                ** while (c != -1 && Character.isJavaIdentifierPart((int)c))
            }
        }
        return position - 1;
    }

    private static boolean isIdentifierQuote(char c, boolean testStart, boolean testEnd, String[][] quoteStrings) {
        String testStr = Character.toString(c);
        if (testStr.equals("\"")) {
            return true;
        }
        if (quoteStrings != null) {
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] quotePair = stringArray[n2];
                if (testStart && testStr.equals(quotePair[0]) || testEnd && testStr.equals(quotePair[1])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

