/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class AssociationCreateCommand
extends Command {
    private static final Log log = Log.getLog(AssociationCreateCommand.class);
    protected ERDAssociation association;
    protected ERDElement<?> sourceEntity;
    protected ERDElement<?> targetEntity;
    protected List<ERDEntityAttribute> sourceAttributes;
    protected List<ERDEntityAttribute> targetAttributes;
    private ERDEditorPart editor;

    public ERDEntityAttribute getSourceAttribute() {
        return CommonUtils.isEmpty(this.sourceAttributes) ? null : this.sourceAttributes.get(0);
    }

    public ERDEntityAttribute getTargetAttribute() {
        return CommonUtils.isEmpty(this.targetAttributes) ? null : this.targetAttributes.get(0);
    }

    public void setAttributes(List<ERDEntityAttribute> sourceAttributes, List<ERDEntityAttribute> targetAttributes) {
        this.sourceAttributes = sourceAttributes;
        this.targetAttributes = targetAttributes;
    }

    public void setAttributes(ERDEntityAttribute sourceAttribute, ERDEntityAttribute targetAttribute) {
        this.sourceAttributes = Collections.singletonList(sourceAttribute);
        this.targetAttributes = Collections.singletonList(targetAttribute);
    }

    public boolean canExecute() {
        if (this.sourceEntity.equals(this.targetEntity)) {
            return false;
        }
        if (this.targetEntity == null) {
            return false;
        }
        return !this.isAssociationExists();
    }

    protected boolean isAssociationExists() {
        List relationships = this.targetEntity.getReferences();
        for (ERDAssociation currentRelationship : relationships) {
            if (!currentRelationship.getSourceEntity().equals(this.sourceEntity)) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        this.association = this.createAssociation(this.sourceEntity, this.targetEntity, true);
    }

    public ERDElement<?> getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(ERDElement<?> sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public ERDElement<?> getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ERDElement<?> targetEntity) {
        this.targetEntity = targetEntity;
    }

    public ERDAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(ERDAssociation association) {
        this.association = association;
    }

    public void redo() {
        if (this.association != null) {
            this.sourceEntity.addAssociation(this.association, true);
            this.targetEntity.addReferenceAssociation(this.association, true);
        }
    }

    public void undo() {
        if (this.association != null) {
            this.sourceEntity.removeAssociation(this.association, true);
            this.targetEntity.removeReferenceAssociation(this.association, true);
        }
    }

    protected ERDAssociation createAssociation(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, boolean reflect) {
        ERDAssociation association = null;
        if (sourceEntity instanceof ERDEntity && targetEntity instanceof ERDEntity) {
            DBSEntity srcEntityObject = (DBSEntity)((ERDEntity)sourceEntity).getObject();
            DBSEntity targetEntityObject = (DBSEntity)((ERDEntity)targetEntity).getObject();
            List srcAttrs = ERDUtils.getObjectsFromERD(this.sourceAttributes);
            List refAttrs = ERDUtils.getObjectsFromERD(this.targetAttributes);
            try {
                if (this.needToSwapForeignKeyDirection((DBRProgressMonitor)new VoidProgressMonitor(), srcAttrs, refAttrs)) {
                    DBSEntity tmpEntity = targetEntityObject;
                    targetEntityObject = srcEntityObject;
                    srcEntityObject = tmpEntity;
                    List tmpAttrs = refAttrs;
                    refAttrs = srcAttrs;
                    srcAttrs = tmpAttrs;
                }
            }
            catch (DBException e) {
                log.error((Object)"Error reading constraints", (Throwable)e);
            }
            DBVEntity vEntity = DBVUtils.getVirtualEntity((DBSEntity)srcEntityObject, (boolean)true);
            assert (vEntity != null);
            DBVEntityForeignKey vfk = EditForeignKeyPage.createVirtualForeignKey((DBVEntity)vEntity, (DBSEntity)targetEntityObject, (EditForeignKeyPage.FKType[])new EditForeignKeyPage.FKType[]{EditForeignKeyPage.FK_TYPE_LOGICAL}, (Collection)srcAttrs, (Collection)refAttrs);
            if (vfk == null) {
                return null;
            }
            vEntity.persistConfiguration();
            if (sourceEntity != null && targetEntity != null) {
                association = new ERDAssociation((DBSEntityAssociation)vfk, (ERDEntity)sourceEntity, (ERDEntity)targetEntity, true);
            }
        } else if (sourceEntity != null && targetEntity != null) {
            association = new ERDAssociation(sourceEntity, targetEntity, true);
        }
        return association;
    }

    public ERDEditorPart getEditor() {
        return this.editor;
    }

    public void setEditor(ERDEditorPart editor) {
        this.editor = editor;
    }

    protected boolean needToSwapForeignKeyDirection(DBRProgressMonitor monitor, List<DBSEntityAttribute> srcAttrs, List<DBSEntityAttribute> targetAttrs) throws DBException {
        return !CommonUtils.isEmpty(srcAttrs) && !CommonUtils.isEmpty(targetAttrs) && !DBVUtils.isIdentifyingAttributes((DBRProgressMonitor)monitor, srcAttrs) && DBVUtils.isIdentifyingAttributes((DBRProgressMonitor)monitor, targetAttrs);
    }
}

