/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.router;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouter;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class ERDConnectionRouterDescriptor
extends AbstractDescriptor {
    private String id;
    private String name;
    private String description;
    private boolean isEnableAttributeAssociation;
    private AbstractDescriptor.ObjectType lazyRouter;
    private Log log = Log.getLog((String)ERDConnectionRouterDescriptor.class.getName());

    protected ERDConnectionRouterDescriptor(IConfigurationElement cf) throws CoreException {
        super(cf);
        this.id = cf.getAttribute("id");
        this.name = cf.getAttribute("name");
        this.description = cf.getAttribute("description");
        this.isEnableAttributeAssociation = CommonUtils.toBoolean((Object)cf.getAttribute("supportAttributesAssociation"));
        this.lazyRouter = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, cf.getAttribute("router"));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ERDConnectionRouter createRouter() {
        try {
            return (ERDConnectionRouter)((Object)this.lazyRouter.createInstance(ERDConnectionRouter.class));
        }
        catch (DBException e) {
            this.log.error((Object)e.getMessage());
            return null;
        }
    }

    public boolean supportedAttributeAssociation() {
        return this.isEnableAttributeAssociation;
    }
}

