/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.router.mikkami;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class OrthogonalPath {
    private boolean isDirty;
    private PointList points;
    private PointList bendpoints;
    private Connection connection;
    private Direction forbiddenDirection;
    private boolean sourceIsChild;
    private boolean targetIsChild;
    Point start;
    Point end;

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void reset() {
        this.sourceIsChild = false;
        this.targetIsChild = false;
        this.forbiddenDirection = null;
    }

    public void updateForbiddenDirection(Point origin) {
        if (this.start.x == origin.x) {
            this.forbiddenDirection = this.start.y > origin.y ? Direction.DOWN : Direction.UP;
        }
        if (this.start.y == origin.y) {
            this.forbiddenDirection = this.start.x > origin.x ? Direction.LEFT : Direction.RIGHT;
        }
    }

    public boolean isSourceIsChild() {
        return this.sourceIsChild;
    }

    public void setSourceIsChild(boolean child) {
        this.sourceIsChild = child;
    }

    public boolean isTargetIsChild() {
        return this.targetIsChild;
    }

    public void setTargetIsChild(boolean child) {
        this.targetIsChild = child;
    }

    public Direction getForbiddenDirection() {
        return this.forbiddenDirection;
    }

    public void setForbiddenDirection(Direction forbiddenDirection) {
        this.forbiddenDirection = forbiddenDirection;
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }

    public PointList getPoints() {
        return this.points;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public OrthogonalPath(Connection conn) {
        this.setDirty(true);
        this.connection = conn;
    }

    public void setStartPoint(Point start) {
        if (!start.equals((Object)this.start)) {
            this.start = start;
            this.isDirty = true;
        }
    }

    public void setEndPoint(Point end) {
        if (!end.equals((Object)this.end)) {
            this.end = end;
            this.isDirty = true;
        }
    }

    public void setPoints(PointList points) {
        this.points = points;
    }

    public PointList getBendpoints() {
        return this.bendpoints;
    }

    public void setBendpoints(PointList bendpoints) {
        this.bendpoints = bendpoints;
        this.setDirty(true);
    }

    public static enum Direction {
        UP,
        DOWN,
        RIGHT,
        LEFT;

    }
}

