/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMEventBrowser;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMMCollector;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.QMRegistry;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.filters.QMCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.runtime.qm.QMMCollectorImpl;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class QMRegistryImpl
implements QMRegistry {
    private static final Log log = Log.getLog(QMRegistryImpl.class);
    private QMExecutionHandler defaultHandler;
    private QMMCollectorImpl metaHandler;
    private final List<QMExecutionHandler> handlers = new ArrayList<QMExecutionHandler>();
    private QMEventBrowser eventBrowser;
    private DefaultEventBrowser defaultEventBrowser = new DefaultEventBrowser();

    public QMRegistryImpl() {
        this.defaultHandler = (QMExecutionHandler)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{QMExecutionHandler.class}, (InvocationHandler)new NotifyInvocationHandler());
        this.metaHandler = new QMMCollectorImpl();
        this.registerHandler(this.metaHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.metaHandler != null) {
            this.unregisterHandler(this.metaHandler);
            this.metaHandler.dispose();
            this.metaHandler = null;
        }
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.isEmpty()) {
                log.warn("Some QM handlers are still registered: " + this.handlers);
                this.handlers.clear();
            }
        }
        this.defaultHandler = null;
    }

    @Override
    public QMMCollector getMetaCollector() {
        return this.metaHandler;
    }

    @Override
    public QMExecutionHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    @Override
    public synchronized QMEventBrowser getEventBrowser(boolean currentSessionOnly) {
        if (currentSessionOnly) {
            return this.defaultEventBrowser;
        }
        if (this.eventBrowser == null) {
            this.eventBrowser = GeneralUtils.adapt(this, QMEventBrowser.class);
            if (this.eventBrowser == null) {
                this.eventBrowser = this.defaultEventBrowser;
            }
        }
        return this.eventBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHandler(QMExecutionHandler handler) {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterHandler(QMExecutionHandler handler) {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.remove(handler)) {
                log.warn("QM handler '" + handler + "' isn't registered within QM controller");
            }
        }
    }

    @Override
    public void registerMetaListener(QMMetaListener metaListener) {
        this.metaHandler.addListener(metaListener);
    }

    @Override
    public void unregisterMetaListener(QMMetaListener metaListener) {
        this.metaHandler.removeListener(metaListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<QMExecutionHandler> getHandlers() {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers;
        }
    }

    private class DefaultEventBrowser
    implements QMEventBrowser {
        private DefaultEventBrowser() {
        }

        @Override
        @NotNull
        public QMEventCursor getQueryHistoryCursor(@NotNull QMCursorFilter cursorFilter) throws DBException {
            List<QMMetaEvent> pastEvents = QMRegistryImpl.this.metaHandler.getPastEvents();
            Collections.reverse(pastEvents);
            QMEventCriteria criteria = cursorFilter.getCriteria();
            QMEventFilter filter = cursorFilter.getFilter();
            if (criteria.getObjectTypes() != null || criteria.getQueryTypes() != null) {
                Iterator<QMMetaEvent> iter = pastEvents.iterator();
                while (iter.hasNext()) {
                    QMMetaEvent event = iter.next();
                    if (criteria.getObjectTypes() != null && !this.matchesObjectType(event.getObject(), criteria.getObjectTypes())) {
                        iter.remove();
                        continue;
                    }
                    if (filter != null && !filter.accept(event)) {
                        iter.remove();
                        continue;
                    }
                    if (criteria.getQueryTypes() == null) continue;
                    QMMStatementInfo statementInfo = null;
                    if (event.getObject() instanceof QMMStatementInfo) {
                        statementInfo = (QMMStatementInfo)event.getObject();
                    } else if (event.getObject() instanceof QMMStatementExecuteInfo) {
                        statementInfo = ((QMMStatementExecuteInfo)event.getObject()).getStatement();
                    }
                    if (statementInfo == null || ArrayUtils.contains((Object[])criteria.getQueryTypes(), (Object)((Object)statementInfo.getPurpose()))) continue;
                    iter.remove();
                }
            }
            if (CommonUtils.isEmpty((String)criteria.getSearchString())) {
                return new QMUtils.ListCursorImpl(pastEvents);
            }
            String searchString = criteria.getSearchString().toLowerCase();
            ArrayList<QMMetaEvent> filtered = new ArrayList<QMMetaEvent>();
            for (QMMetaEvent event : pastEvents) {
                if (!event.getObject().getText().toLowerCase().contains(searchString) || filter != null && !filter.accept(event)) continue;
                filtered.add(event);
            }
            return new QMUtils.ListCursorImpl(filtered);
        }

        private boolean matchesObjectType(QMMObject object, QMObjectType[] objectTypes) {
            if (object instanceof QMMConnectionInfo) {
                return ArrayUtils.contains((Object[])objectTypes, (Object)((Object)QMObjectType.session));
            }
            if (object instanceof QMMTransactionInfo || object instanceof QMMTransactionSavepointInfo) {
                return ArrayUtils.contains((Object[])objectTypes, (Object)((Object)QMObjectType.txn));
            }
            return ArrayUtils.contains((Object[])objectTypes, (Object)((Object)QMObjectType.query));
        }
    }

    private class NotifyInvocationHandler
    implements InvocationHandler {
        private NotifyInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            block11: {
                block10: {
                    try {
                        QMExecutionHandler[] handlersCopy;
                        if (method.getReturnType() != Void.TYPE || !method.getName().startsWith("handle")) break block10;
                        List<QMExecutionHandler> list = QMRegistryImpl.this.handlers;
                        synchronized (list) {
                            handlersCopy = QMRegistryImpl.this.handlers.toArray(new QMExecutionHandler[QMRegistryImpl.this.handlers.size()]);
                        }
                        QMExecutionHandler[] qMExecutionHandlerArray = handlersCopy;
                        int n = handlersCopy.length;
                        int n2 = 0;
                        while (n2 < n) {
                            QMExecutionHandler handler = qMExecutionHandlerArray[n2];
                            try {
                                method.invoke((Object)handler, args);
                            }
                            catch (InvocationTargetException e) {
                                log.debug("Error notifying QM handler '" + handler.getHandlerName() + "'", e.getTargetException());
                            }
                            ++n2;
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        log.debug("Error executing QM method " + method, e);
                        return null;
                    }
                }
                if (!method.getName().equals("getHandlerName")) break block11;
                return "Default";
            }
            return method.invoke((Object)this, args);
        }
    }
}

