/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.util.Date;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;

public class DataTransferPipe {
    private IDataTransferProducer producer;
    private IDataTransferConsumer consumer;

    public DataTransferPipe(IDataTransferProducer producer, IDataTransferConsumer consumer) {
        this.producer = producer;
        this.consumer = consumer;
    }

    public IDataTransferProducer<?> getProducer() {
        return this.producer;
    }

    public void setProducer(IDataTransferProducer<?> producer) {
        this.producer = producer;
    }

    public IDataTransferConsumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(IDataTransferConsumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    public void initPipe(DataTransferSettings settings, int pipeIndex, int totalPipes) throws DBException {
        if (this.consumer == null || this.producer == null) {
            throw new DBException("Empty pipe");
        }
        IDataTransferSettings consumerSettings = settings.getNodeSettings(settings.getConsumer());
        DataTransferProcessorDescriptor processorDescriptor = settings.getProcessor();
        IDataTransferProcessor processor = processorDescriptor == null ? null : processorDescriptor.getInstance();
        IDataTransferConsumer.TransferParameters parameters = new IDataTransferConsumer.TransferParameters(processorDescriptor != null && processorDescriptor.isBinaryFormat(), processorDescriptor != null && processorDescriptor.isHTMLFormat());
        parameters.orderNumber = pipeIndex;
        parameters.totalConsumers = totalPipes;
        parameters.startTimestamp = new Date();
        this.consumer.initTransfer(this.producer.getDatabaseObject(), consumerSettings, parameters, processor, processor == null ? null : settings.getProcessorProperties(), this.producer == null ? null : this.producer.getProject());
    }
}

