/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCNumberValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class MySQLNumberValueHandler
extends JDBCNumberValueHandler {
    public MySQLNumberValueHandler(DBSTypedObject type, DBDFormatSettings formatSettings) {
        super(type, formatSettings);
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof String) {
            if (format == DBDDisplayFormat.UI || format == DBDDisplayFormat.NATIVE) {
                return "b'" + value + "'";
            }
            return (String)value;
        }
        return super.getValueDisplayString(column, value, format);
    }

    protected boolean isReadDecimalsAsDouble() {
        return true;
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException, DBCException {
        if (value instanceof String) {
            String strValue = (String)value;
            if (paramType.getTypeID() == -7) {
                long longValue;
                try {
                    longValue = Long.parseLong(strValue, 2);
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Can't convert value '" + value + "' into bit string", e);
                }
                if (CommonUtils.toInt((Object)paramType.getPrecision()) <= 1) {
                    statement.setByte(paramIndex, (byte)longValue);
                } else {
                    statement.setLong(paramIndex, longValue);
                }
                return;
            }
        }
        super.bindParameter(session, statement, paramType, paramIndex, value);
    }
}

