/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.utils.CommonUtils;

public abstract class OracleTablePhysical
extends OracleTableBase
implements DBSObjectLazy<OracleDataSource>,
DBSPartitionContainer {
    private static final Log log = Log.getLog(OracleTablePhysical.class);
    private long rowCount;
    private Long realRowCount;
    private Object tablespace;
    private boolean partitioned;
    private PartitionInfo partitionInfo;
    private PartitionCache partitionCache;

    protected OracleTablePhysical(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    protected OracleTablePhysical(OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
        this.readSpecialProperties(dbResult);
        this.partitioned = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PARTITIONED", (String)"Y");
        this.partitionCache = this.partitioned ? new PartitionCache() : null;
    }

    protected OracleTablePhysical(@NotNull OracleSchema schema, @NotNull ResultSet dbResult, @NotNull String name) {
        super(schema, name);
        this.readSpecialProperties(dbResult);
        this.partitioned = false;
    }

    private void readSpecialProperties(@NotNull ResultSet dbResult) {
        this.rowCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_ROWS");
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
    }

    @Property(category="Statistics", viewable=true, order=20)
    public long getRowCount() {
        return this.rowCount;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=21)
    public synchronized Long getRealRowCount(DBRProgressMonitor monitor) {
        if (this.realRowCount != null) {
            return this.realRowCount;
        }
        if (!this.isPersisted()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.realRowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.realRowCount == null) {
            this.realRowCount = -1L;
        }
        return this.realRowCount;
    }

    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    @Property(viewable=true, order=22, editable=true, updatable=true, listProvider=TablespaceListProvider.class)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    public Object getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(OracleTablespace tablespace) {
        this.tablespace = tablespace;
    }

    @Association
    public Collection<OracleTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).indexCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableIndex getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleTableIndex)((OracleSchema)this.getContainer()).indexCache.getObject(monitor, (OracleSchema)this.getContainer(), this, name);
    }

    public PartitionCache getPartitionCache() {
        return this.partitionCache;
    }

    @PropertyGroup
    @LazyProperty(cacheValidator=PartitionInfoValidator.class)
    public PartitionInfo getPartitionInfo(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionInfo == null && this.partitioned) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load partitioning info");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM ALL_PART_TABLES WHERE OWNER=? AND TABLE_NAME=?");){
                        dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.partitionInfo = new PartitionInfo(monitor, (OracleDataSource)this.getDataSource(), (ResultSet)dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, this.getDataSource());
            }
        }
        return this.partitionInfo;
    }

    @Property(viewable=true, order=13)
    @Association
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Association
    public Collection<OracleTablePartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionCache == null) {
            return Collections.emptyList();
        }
        return this.partitionCache.getAllObjects(monitor, this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).indexCache.clearObjectCache(this);
        if (this.partitionCache != null) {
            this.partitionCache.clearCache();
            this.partitionInfo = null;
        }
        return super.refreshObject(monitor);
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.TABLE);
    }

    private static class PartitionCache
    extends JDBCObjectLookupCache<OracleTablePhysical, OracleTablePartition> {
        private PartitionCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @Nullable OracleTablePartition partition, @Nullable String partitionName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix((OracleDataSource)table.getDataSource()) + "ALL_TAB_PARTITIONS " + "\nWHERE TABLE_OWNER=? AND TABLE_NAME=? " + (partition != null || CommonUtils.isNotEmpty((String)partitionName) ? " AND PARTITION_NAME=?" : "") + "\nORDER BY PARTITION_POSITION");
            dbStat.setString(1, ((OracleSchema)table.getContainer()).getName());
            dbStat.setString(2, table.getName());
            if (partition != null || CommonUtils.isNotEmpty((String)partitionName)) {
                dbStat.setString(3, partition != null ? partition.getName() : partitionName);
            }
            return dbStat;
        }

        protected OracleTablePartition fetchObject(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String partitionName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PARTITION_NAME");
            if (CommonUtils.isEmpty((String)partitionName)) {
                return null;
            }
            return new OracleTablePartition(table, partitionName, (ResultSet)resultSet, null);
        }
    }

    public static class PartitionInfo
    extends OracleTablePartition.PartitionInfoBase {
        public PartitionInfo(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) {
            super(monitor, dataSource, dbResult);
        }
    }

    public static class PartitionInfoValidator
    implements IPropertyCacheValidator<OracleTablePhysical> {
        public boolean isPropertyCached(OracleTablePhysical object, Object propertyId) {
            return object.partitioned && object.partitionInfo != null;
        }
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<OracleTablePhysical> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(OracleTablePhysical object) {
            ArrayList<OracleTablespace> tablespaces = new ArrayList<OracleTablespace>();
            try {
                tablespaces.addAll(((OracleDataSource)object.getDataSource()).getTablespaces((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)e);
            }
            tablespaces.sort(DBUtils.nameComparator());
            return tablespaces.toArray(new OracleTablespace[tablespaces.size()]);
        }
    }
}

