/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.edit.OracleTableColumnManager;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleExecutionContext;
import org.jkiss.dbeaver.ext.oracle.model.OracleMaterializedView;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class OracleUtils {
    private static final Log log = Log.getLog(OracleUtils.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDDL(DBRProgressMonitor monitor, String objectType, OracleTableBase object, OracleDDLFormat ddlFormat, Map<String, Object> options) throws DBException {
        if (monitor.isCanceled()) {
            return "";
        }
        String objectFullName = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        OracleSchema schema = (OracleSchema)object.getContainer();
        OracleDataSource dataSource = (OracleDataSource)object.getDataSource();
        monitor.subTask("Load sources for " + objectType + " '" + objectFullName + "'...");
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)("Load source code for " + objectType + " '" + objectFullName + "'"));){
                String ddl;
                if (CommonUtils.getOption(options, (String)"ddl.onlyForeignKeys")) {
                    if (CommonUtils.isEmpty(object.getConstraints(monitor))) return "";
                    return OracleUtils.invokeDBMSMetadataGetDependentDDL(session, schema, object, DBMSMetaDependentObjectType.REF_CONSTRAINT);
                }
                if (dataSource.isAtLeastV9()) {
                    try {
                        JDBCUtils.executeProcedure((Connection)session, (String)("begin\nDBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'SQLTERMINATOR',true);\nDBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'STORAGE'," + ddlFormat.isShowStorage() + ");\n" + "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'TABLESPACE'," + ddlFormat.isShowTablespace() + ");\n" + "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'SEGMENT_ATTRIBUTES'," + ddlFormat.isShowSegments() + ");\n" + "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'EMIT_SCHEMA'," + CommonUtils.getOption(options, (String)"useFQN", (boolean)true) + ");\n" + "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS',true);\n" + "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'REF_CONSTRAINTS'," + !CommonUtils.getOption(options, (String)"ddl.separateForeignKeys", (boolean)true) + ");\n" + "end;"));
                    }
                    catch (SQLException e) {
                        log.error((Object)"Can't apply DDL transform parameters", (Throwable)e);
                    }
                }
                if (monitor.isCanceled()) {
                    return "";
                }
                Throwable throwable2 = null;
                Object var13_18 = null;
                try {
                    JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DBMS_METADATA.GET_DDL(?,?" + (schema == null ? "" : ",?") + ") TXT FROM DUAL");
                    dbStat.setString(1, objectType);
                    dbStat.setString(2, object.getName());
                    if (schema != null) {
                        dbStat.setString(3, schema.getName());
                    }
                    Throwable throwable3 = null;
                    Object var16_23 = null;
                    try {
                        JDBCResultSet dbResult;
                        block60: {
                            block61: {
                                dbResult = dbStat.executeQuery();
                                if (dbResult.next()) {
                                    Object ddlValue = dbResult.getObject(1);
                                    if (ddlValue instanceof Clob) {
                                        StringWriter buf = new StringWriter();
                                        try {
                                            Throwable throwable4 = null;
                                            Object var21_31 = null;
                                            try (Reader clobReader = ((Clob)ddlValue).getCharacterStream();){
                                                IOUtils.copyText((Reader)clobReader, (Writer)buf);
                                            }
                                            catch (Throwable throwable5) {
                                                if (throwable4 == null) {
                                                    throwable4 = throwable5;
                                                    throw throwable4;
                                                }
                                                if (throwable4 == throwable5) throw throwable4;
                                                throwable4.addSuppressed(throwable5);
                                                throw throwable4;
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace(new PrintWriter((Writer)buf, true));
                                        }
                                        ddl = buf.toString();
                                        break block60;
                                    }
                                    ddl = CommonUtils.toString((Object)ddlValue);
                                    break block60;
                                }
                                log.warn((Object)("No DDL for " + objectType + " '" + objectFullName + "'"));
                                if (dbResult == null) break block61;
                                {
                                    catch (Throwable throwable6) {
                                        if (dbResult == null) throw throwable6;
                                        dbResult.close();
                                        throw throwable6;
                                    }
                                }
                                dbResult.close();
                            }
                            if (dbStat == null) return "-- EMPTY DDL";
                            dbStat.close();
                            return "-- EMPTY DDL";
                        }
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable3 == null) {
                            throwable3 = throwable7;
                            throw throwable3;
                        }
                        if (throwable3 == throwable7) throw throwable3;
                        throwable3.addSuppressed(throwable7);
                        throw throwable3;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable2 == null) {
                        throwable2 = throwable8;
                        throw throwable2;
                    }
                    if (throwable2 == throwable8) throw throwable2;
                    throwable2.addSuppressed(throwable8);
                    throw throwable2;
                }
                ddl = ddl.trim();
                if (monitor.isCanceled()) {
                    return ddl;
                }
                if (!CommonUtils.isEmpty(object.getConstraints(monitor)) && !CommonUtils.getOption(options, (String)"ddl.skipForeignKeys") && CommonUtils.getOption(options, (String)"ddl.separateForeignKeys")) {
                    ddl = String.valueOf(ddl) + OracleUtils.invokeDBMSMetadataGetDependentDDL(session, schema, object, DBMSMetaDependentObjectType.REF_CONSTRAINT);
                }
                if (monitor.isCanceled()) {
                    return ddl;
                }
                if (!CommonUtils.isEmpty(object.getTriggers(monitor))) {
                    ddl = String.valueOf(ddl) + OracleUtils.invokeDBMSMetadataGetDependentDDL(session, schema, object, DBMSMetaDependentObjectType.TRIGGER);
                }
                if (monitor.isCanceled()) {
                    return ddl;
                }
                if (!CommonUtils.isEmpty(object.getIndexes(monitor))) {
                    ddl = String.valueOf(ddl) + OracleUtils.invokeDBMSMetadataGetDependentDDL(session, schema, object, DBMSMetaDependentObjectType.INDEX);
                }
                if (monitor.isCanceled()) {
                    return ddl;
                }
                if (ddlFormat == OracleDDLFormat.FULL) {
                    ddl = String.valueOf(ddl) + OracleUtils.invokeDBMSMetadataGetDependentDDL(session, schema, object, DBMSMetaDependentObjectType.OBJECT_GRANT);
                }
                if (monitor.isCanceled()) {
                    return ddl;
                }
                if (ddlFormat == OracleDDLFormat.COMPACT) return ddl;
                ddl = OracleUtils.addCommentsToDDL(monitor, object, ddl);
                return ddl;
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                    throw throwable;
                }
                if (throwable == throwable9) throw throwable;
                throwable.addSuppressed(throwable9);
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (!(object instanceof OracleTablePhysical)) throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            log.error((Object)"Error generating Oracle DDL. Generate default.", (Throwable)e);
            return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)object, options, (boolean)true);
        }
    }

    private static String invokeDBMSMetadataGetDependentDDL(JDBCSession session, OracleSchema schema, OracleTableBase object, DBMSMetaDependentObjectType dependentObjectType) {
        String ddl = "";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DBMS_METADATA.GET_DEPENDENT_DDL('" + dependentObjectType.name() + "',?" + (schema == null ? "" : ",?") + ") TXT FROM DUAL");){
                dbStat.setString(1, object.getName());
                if (schema != null) {
                    dbStat.setString(2, schema.getName());
                }
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    if (dbResult.next()) {
                        ddl = "\n\n" + dbResult.getString(1).trim();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Error reading dependent DDL '" + (Object)((Object)dependentObjectType) + "' for '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "': " + e.getMessage()));
        }
        return ddl;
    }

    private static String addCommentsToDDL(DBRProgressMonitor monitor, OracleTableBase object, String ddl) {
        StringBuilder ddlBuilder = new StringBuilder(ddl);
        String objectFullName = object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        String objectComment = object.getComment(monitor);
        if (!CommonUtils.isEmpty((String)objectComment)) {
            String objectTypeName = "TABLE";
            if (object instanceof OracleMaterializedView) {
                objectTypeName = "MATERIALIZED VIEW";
            }
            ddlBuilder.append("\n\n").append("COMMENT ON ").append(objectTypeName).append(" ").append(objectFullName).append(" IS ").append(SQLUtils.quoteString((DBPDataSource)object.getDataSource(), (String)objectComment)).append(";");
        }
        try {
            List<OracleTableColumn> attributes = object.getAttributes(monitor);
            if (!CommonUtils.isEmpty(attributes)) {
                ArrayList actions = new ArrayList();
                if (CommonUtils.isEmpty((String)objectComment)) {
                    ddlBuilder.append("\n");
                }
                for (OracleTableColumn column : CommonUtils.safeCollection(attributes)) {
                    String columnComment = column.getComment(monitor);
                    if (CommonUtils.isEmpty((String)columnComment)) continue;
                    OracleTableColumnManager.addColumnCommentAction(actions, (DBSEntityAttribute)column, (DBSEntity)column.getTable());
                }
                if (!CommonUtils.isEmpty(actions)) {
                    for (DBEPersistAction action : actions) {
                        ddlBuilder.append("\n").append(action.getScript()).append(";");
                    }
                }
            }
        }
        catch (DBException e) {
            log.debug((Object)"Error reading object columns", (Throwable)e);
        }
        return ddlBuilder.toString();
    }

    public static void setCurrentSchema(JDBCSession session, String schema) throws SQLException {
        JDBCUtils.executeSQL((Connection)session, (String)("ALTER SESSION SET CURRENT_SCHEMA=" + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)schema)), (Object[])new Object[0]);
    }

    public static String getCurrentSchema(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((Connection)session, (String)"SELECT SYS_CONTEXT( 'USERENV', 'CURRENT_SCHEMA' ) FROM DUAL", (Object[])new Object[0]);
    }

    public static String normalizeSourceName(OracleSourceObject object, boolean body) {
        String objectName;
        String source;
        block5: {
            try {
                String string = source = body ? ((DBPScriptObjectExt)object).getExtendedDefinitionText(null) : object.getObjectDefinitionText(null, DBPScriptObject.EMPTY_OPTIONS);
                if (source != null) break block5;
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        Pattern pattern = Pattern.compile("\\b" + (Object)((Object)object.getSourceType()) + "\\b" + (body ? "\\s+BODY" : "") + "\\s(\\s*)([\\w$\\.\\\"]+)[\\s\\(]+", 2);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find() && (objectName = matcher.group(2)).indexOf(46) == -1) {
            if (!objectName.equalsIgnoreCase(object.getName())) {
                object.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)object, (String)objectName));
                object.getDataSource().getContainer().fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)object));
            }
            return source;
        }
        return source.trim();
    }

    public static void addSchemaChangeActions(DBCExecutionContext executionContext, List<DBEPersistAction> actions, OracleSourceObject object) {
        OracleSchema schema = object.getSchema();
        if (schema == null) {
            return;
        }
        actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction("Set target schema", "ALTER SESSION SET CURRENT_SCHEMA=" + schema.getName(), DBEPersistAction.ActionType.INITIALIZER));
        OracleSchema defaultSchema = ((OracleExecutionContext)executionContext).getDefaultSchema();
        if (schema != defaultSchema && defaultSchema != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema", "ALTER SESSION SET CURRENT_SCHEMA=" + defaultSchema.getName(), DBEPersistAction.ActionType.FINALIZER));
        }
    }

    public static String getSysSchemaPrefix(OracleDataSource dataSource) {
        boolean useSysView = CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-meta-use-sys-schema@"));
        if (useSysView) {
            return "SYS.";
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public static String getSource(DBRProgressMonitor monitor, OracleSourceObject sourceObject, boolean body, boolean insertCreateReplace) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 12 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getSysUserViewName(DBRProgressMonitor monitor, OracleDataSource dataSource, String viewName) {
        String dbaView = "DBA_" + viewName;
        if (dataSource.isViewAvailable(monitor, "SYS", dbaView)) {
            return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + dbaView;
        }
        return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + "USER_" + viewName;
    }

    public static String getAdminAllViewPrefix(DBRProgressMonitor monitor, OracleDataSource dataSource, String viewName) {
        String dbaView;
        boolean useDBAView = CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-always-use-dba-views@"));
        if (useDBAView && dataSource.isViewAvailable(monitor, "SYS", dbaView = "DBA_" + viewName)) {
            return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + dbaView;
        }
        return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + "ALL_" + viewName;
    }

    public static String getSysCatalogHint(OracleDataSource dataSource) {
        return dataSource.isUseRuleHint() ? "/*+RULE*/" : "";
    }

    static <PARENT extends DBSObject> Object resolveLazyReference(DBRProgressMonitor monitor, PARENT parent, DBSObjectCache<PARENT, ?> cache, DBSObjectLazy<?> referrer, Object propertyId) throws DBException {
        Object reference = referrer.getLazyReference(propertyId);
        if (reference instanceof String) {
            DBSObject object = monitor != null ? cache.getObject(monitor, parent, (String)reference) : cache.getCachedObject((String)reference);
            if (object != null) {
                return object;
            }
            log.warn((Object)("Object '" + reference + "' not found"));
            return reference;
        }
        return reference;
    }

    /*
     * Exception decompiling
     */
    public static boolean getObjectStatus(DBRProgressMonitor monitor, OracleStatefulObject object, OracleObjectType objectType) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String insertCreateReplace(OracleSourceObject object, boolean body, String source) {
        Pattern srcPattern;
        Matcher matcher;
        String sourceType = object.getSourceType().name();
        if (body) {
            sourceType = String.valueOf(sourceType) + " BODY";
        }
        if ((matcher = (srcPattern = Pattern.compile("^(" + sourceType + ")\\s+(\"{0,1}\\w+\"{0,1})", 2)).matcher(source)).find()) {
            return "CREATE OR REPLACE " + matcher.group(1) + " " + DBUtils.getQuotedIdentifier((DBSObject)object.getSchema()) + "." + matcher.group(2) + source.substring(matcher.end());
        }
        return source;
    }

    public static String formatWord(String word) {
        if (word == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(word.length());
        sb.append(Character.toUpperCase(word.charAt(0)));
        int i = 1;
        while (i < word.length()) {
            char c = word.charAt(i);
            if ((c == 'i' || c == 'I') && sb.charAt(i - 1) == 'I') {
                sb.append('I');
            } else {
                sb.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatSentence(String sent) {
        if (sent == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sent, " \t\n\r-,.\\/", true);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.length() <= 0) continue;
            result.append(OracleUtils.formatWord(word));
        }
        return result.toString();
    }

    private static enum DBMSMetaDependentObjectType {
        INDEX,
        CONSTRAINT,
        REF_CONSTRAINT,
        TRIGGER,
        OBJECT_GRANT;

    }
}

