/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.cache.ListCache;

public class GenericProcedureManager
extends SQLObjectEditor<GenericProcedure, GenericStructContainer> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericProcedure> getObjectsCache(GenericProcedure object) {
        GenericStructContainer container = (GenericStructContainer)object.getContainer();
        return new ListCache(((GenericObjectContainer)container).getProcedureCache());
    }

    protected GenericProcedure createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String procedureName;
        GenericProcedure object = (GenericProcedure)command.getObject();
        GenericMetaModel metaModel = ((GenericDataSource)object.getDataSource()).getMetaModel();
        if (metaModel.supportsOverloadedProcedureNames()) {
            try {
                procedureName = object.getProcedureSignature(monitor, metaModel.showProcedureParamNames());
            }
            catch (DBException e) {
                log.debug((Object)"Can't read procedure/function parameters", (Throwable)e);
                procedureName = object.getFullyQualifiedName(DBPEvaluationContext.DDL);
            }
        } else {
            procedureName = object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + object.getProcedureType().name() + " " + procedureName));
    }

    public boolean canCreateObject(Object container) {
        return false;
    }

    public boolean canDeleteObject(GenericProcedure object) {
        return true;
    }
}

