/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class BasePolicyDataProvider {
    private static final String DBEAVER_REGESTRY_POLICY_NODE = "Software\\DBeaver Corp\\DBeaver\\policy";
    private static BasePolicyDataProvider instance = new BasePolicyDataProvider();

    public static BasePolicyDataProvider getInstance() {
        return instance;
    }

    private BasePolicyDataProvider() {
    }

    public boolean isPolicyEnabled(String propertyName) {
        boolean policyEnabled = false;
        policyEnabled = this.getDataPolicyFromSystem(propertyName);
        if (policyEnabled) {
            return policyEnabled;
        }
        policyEnabled = this.getDataPolicyFromRegistry(propertyName);
        return policyEnabled;
    }

    private boolean getDataPolicyFromSystem(String property) {
        String policyValue = System.getProperty(property);
        if (policyValue != null && !policyValue.isEmpty()) {
            return Boolean.valueOf(policyValue);
        }
        return false;
    }

    private boolean getDataPolicyFromRegistry(String property) {
        if (RuntimeUtils.isWindows()) {
            boolean isPolicyEnabled = this.getBooleanFromWinRegistryNode(WinReg.HKEY_CURRENT_USER, property);
            if (isPolicyEnabled) {
                return isPolicyEnabled;
            }
            isPolicyEnabled = this.getBooleanFromWinRegistryNode(WinReg.HKEY_LOCAL_MACHINE, property);
            if (isPolicyEnabled) {
                return isPolicyEnabled;
            }
        }
        return false;
    }

    private boolean getBooleanFromWinRegistryNode(WinReg.HKEY root, String property) {
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)DBEAVER_REGESTRY_POLICY_NODE) && Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)DBEAVER_REGESTRY_POLICY_NODE, (String)property)) {
            String propRegisrtryValue = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)DBEAVER_REGESTRY_POLICY_NODE, (String)property);
            return Boolean.valueOf(propRegisrtryValue);
        }
        return false;
    }
}

