/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;

public class LocalFileController
implements DBFileController {
    protected final Path dataFolder;

    public LocalFileController(Path dataFolder) {
        this.dataFolder = dataFolder;
    }

    public byte[] loadFileData(@NotNull String fileType, @NotNull String filePath) throws DBException {
        Path targetPath = this.getTargetPath(this.dataFolder, fileType, filePath);
        return this.getBytes(targetPath);
    }

    public void saveFileData(@NotNull String fileType, @NotNull String filePath, byte[] fileData) throws DBException {
        Path targetPath = this.getTargetPath(this.dataFolder, fileType, filePath);
        try {
            if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            }
            Files.write(targetPath, fileData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DBException("Error writing file '" + targetPath.toAbsolutePath() + "' data: " + e.getMessage(), (Throwable)e);
        }
    }

    public String[] listFiles(@NotNull String fileType, @NotNull String filePath) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public void deleteFile(@NotNull String fileType, @NotNull String filePath, boolean recursive) throws DBException {
        Path targetPath = this.getTargetPath(this.dataFolder, fileType, filePath);
        try {
            Files.delete(targetPath);
        }
        catch (IOException e) {
            throw new DBException("Error deleting file '" + targetPath.toAbsolutePath() + "' data: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    protected byte[] getBytes(Path targetPath) throws DBException {
        try {
            return Files.readAllBytes(targetPath);
        }
        catch (IOException e) {
            throw new DBException("Error reading file '" + targetPath.toAbsolutePath() + "' data", (Throwable)e);
        }
    }

    @NotNull
    protected Path getTargetPath(@NotNull Path folder, @NotNull String fileType, @NotNull String filePath) {
        return folder.resolve(fileType).resolve(Path.of(filePath, new String[0]));
    }
}

