/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.service.prefs.BackingStoreException;

public class ResourceTypeDescriptor
extends AbstractDescriptor
implements DBPResourceTypeDescriptor {
    private static final Log log = Log.getLog(ResourceTypeDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resourceType";
    private final String id;
    private final String name;
    private final DBPImage icon;
    private final DBPImage folderIcon;
    private final boolean managable;
    private final List<IContentType> contentTypes = new ArrayList<IContentType>();
    private final List<AbstractDescriptor.ObjectType> resourceTypes = new ArrayList<AbstractDescriptor.ObjectType>();
    private final List<String> roots = new ArrayList<String>();
    private String defaultRoot;
    private final Map<String, String> projectRoots = new HashMap<String, String>();

    public ResourceTypeDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.folderIcon = this.iconToImage(config.getAttribute("folderIcon"));
        this.managable = CommonUtils.toBoolean((Object)config.getAttribute("managable"));
        for (IConfigurationElement contentTypeBinding : ArrayUtils.safeArray((Object[])config.getChildren("contentTypeBinding"))) {
            String contentTypeId = contentTypeBinding.getAttribute("contentTypeId");
            if (CommonUtils.isEmpty((String)contentTypeId)) continue;
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
            if (contentType != null) {
                this.contentTypes.add(contentType);
                continue;
            }
            log.warn((Object)("Content type '" + contentTypeId + "' not recognized"));
        }
        for (IConfigurationElement resourceTypeBinding : ArrayUtils.safeArray((Object[])config.getChildren("resourceTypeBinding"))) {
            String resourceType = resourceTypeBinding.getAttribute("resourceType");
            if (CommonUtils.isEmpty((String)resourceType)) continue;
            this.resourceTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, resourceType));
        }
        for (IConfigurationElement rootConfig : ArrayUtils.safeArray((Object[])config.getChildren("root"))) {
            String folder = rootConfig.getAttribute("folder");
            if (!CommonUtils.isEmpty((String)folder)) {
                this.roots.add(folder);
            }
            if (!"true".equals(rootConfig.getAttribute("default"))) continue;
            this.defaultRoot = folder;
        }
        if (CommonUtils.isEmpty((String)this.defaultRoot) && !CommonUtils.isEmpty(this.roots)) {
            this.defaultRoot = this.roots.get(0);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public DBPImage getFolderIcon() {
        return this.folderIcon;
    }

    public String[] getFileExtensions() {
        LinkedHashSet extensions = new LinkedHashSet();
        for (IContentType contentType : this.contentTypes) {
            Object[] ctExtensions = contentType.getFileSpecs(8);
            if (ArrayUtils.isEmpty((Object[])ctExtensions)) continue;
            Collections.addAll(extensions, ctExtensions);
        }
        return extensions.toArray(new String[0]);
    }

    public Collection<IContentType> getContentTypes() {
        return this.contentTypes;
    }

    public Collection<AbstractDescriptor.ObjectType> getResourceTypes() {
        return this.resourceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultRoot(DBPProject project) {
        String root;
        if (project == null) {
            return this.defaultRoot;
        }
        Map<String, String> map = this.projectRoots;
        synchronized (map) {
            root = this.projectRoots.get(project.getName());
            if (root != null) {
                return root;
            }
        }
        if (project.getEclipseProject() != null) {
            try {
                IEclipsePreferences eclipsePreferences = ResourceTypeDescriptor.getResourceHandlerPreferences(project, "resourceRootFolder");
                root = eclipsePreferences.get(this.id, this.defaultRoot);
                boolean isInvalidRoot = root != null && CommonUtils.isEmptyTrimmed((String)root);
                Map<String, String> map2 = this.projectRoots;
                synchronized (map2) {
                    this.projectRoots.put(project.getName(), isInvalidRoot ? this.defaultRoot : root);
                }
                if (isInvalidRoot) {
                    root = this.defaultRoot;
                    eclipsePreferences.put(this.id, root);
                    try {
                        eclipsePreferences.flush();
                    }
                    catch (BackingStoreException e) {
                        log.error((Object)e);
                    }
                }
                return root;
            }
            catch (Exception e) {
                log.error((Object)"Can't obtain resource handler preferences", (Throwable)e);
                return this.defaultRoot;
            }
        }
        return this.defaultRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRoot(DBPProject project, String rootPath) {
        IEclipsePreferences resourceHandlers = ResourceTypeDescriptor.getResourceHandlerPreferences(project, "resourceRootFolder");
        resourceHandlers.put(this.getId(), rootPath);
        Map<String, String> map = this.projectRoots;
        synchronized (map) {
            this.projectRoots.put(project.getName(), rootPath);
        }
        try {
            resourceHandlers.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
        }
    }

    public boolean isManagable() {
        return this.managable;
    }

    public boolean isApplicableTo(IResource resource, boolean testContent) {
        if (!this.contentTypes.isEmpty() && resource instanceof IFile) {
            if (testContent) {
                try {
                    IContentType fileContentType;
                    IContentDescription contentDescription = ((IFile)resource).getContentDescription();
                    if (contentDescription != null && (fileContentType = contentDescription.getContentType()) != null && this.contentTypes.contains(fileContentType)) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    log.debug((Object)("Can't obtain content description for '" + resource.getName() + "'"), (Throwable)e);
                }
            }
            String fileExtension = resource.getFileExtension();
            for (IContentType contentType : this.contentTypes) {
                Object[] ctExtensions = contentType.getFileSpecs(8);
                if (ArrayUtils.isEmpty((Object[])ctExtensions)) continue;
                Object[] objectArray = ctExtensions;
                int n = ctExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ext = objectArray[n2];
                    if (((String)ext).equalsIgnoreCase(fileExtension)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        if (!this.resourceTypes.isEmpty()) {
            for (AbstractDescriptor.ObjectType objectType : this.resourceTypes) {
                if (!objectType.appliesTo((Object)resource, null)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public String toString() {
        return this.id;
    }

    private static IEclipsePreferences getResourceHandlerPreferences(DBPProject project, String node) {
        IEclipsePreferences projectSettings = ResourceTypeDescriptor.getProjectPreferences(project);
        return (IEclipsePreferences)projectSettings.node(node);
    }

    private static synchronized IEclipsePreferences getProjectPreferences(DBPProject project) {
        return new ProjectScope(project.getEclipseProject()).getNode("org.jkiss.dbeaver.project.resources");
    }
}

