/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.IRule;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLPassiveSyntaxRule;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQuerySelectionModel;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLBackgroundParsingJob {
    private static final Log log = Log.getLog(SQLBackgroundParsingJob.class);
    private static final boolean DEBUG = false;
    private static final Timer schedulingTimer = new Timer("SQLBackgroundParsingJob.schedulingTimer.thread", true);
    private static final long schedulingTimeoutMilliseconds = 500L;
    private final OffsetKeyedTreeMap<QueuedRegionInfo> queuedForReparse = new OffsetKeyedTreeMap();
    private final Object syncRoot = new Object();
    private final SQLEditorBase editor;
    private final SQLDocumentSyntaxContext context = new SQLDocumentSyntaxContext();
    private IDocument document = null;
    private volatile TimerTask task = null;
    private volatile boolean isRunning = false;
    private volatile int knownRegionStart = 0;
    private volatile int knownRegionEnd = 0;
    private final DocumentLifecycleListener documentListener = new DocumentLifecycleListener();

    public SQLBackgroundParsingJob(SQLEditorBase editor) {
        this.editor = editor;
    }

    public SQLDocumentSyntaxContext getCurrentContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getTextViewer() != null) {
                IDocument document;
                this.editor.getTextViewer().addTextInputListener((ITextInputListener)this.documentListener);
                this.editor.getTextViewer().addViewportListener((IViewportListener)this.documentListener);
                if (this.document == null && (document = this.editor.getTextViewer().getDocument()) != null) {
                    this.document = document;
                    this.document.addDocumentListener((IDocumentListener)this.documentListener);
                }
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.cancel();
            TextViewer textViewer = this.editor.getTextViewer();
            if (textViewer != null) {
                textViewer.removeViewportListener((IViewportListener)this.documentListener);
                textViewer.removeTextInputListener((ITextInputListener)this.documentListener);
                if (this.document != null) {
                    this.document.removeDocumentListener((IDocumentListener)this.documentListener);
                }
            }
        }
    }

    @NotNull
    private SQLDocumentSyntaxContext getContext() {
        return this.context;
    }

    @NotNull
    public IRule[] prepareRules(@NotNull SQLRuleScanner sqlRuleScanner) {
        return new IRule[]{new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_TABLE), new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_TABLE_ALIAS), new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_COLUMN), new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_COLUMN_DERIVED), new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_SCHEMA), new SQLPassiveSyntaxRule(this, sqlRuleScanner, SQLTokenType.T_SEMANTIC_ERROR)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeDocumentModification(DocumentEvent event) {
        this.cancel();
        IRegion regionToReparse = this.context.applyDelta(event.getOffset(), event.getLength(), event.getText().length());
        int reparseStart = regionToReparse.getOffset();
        int reparseLength = regionToReparse.getLength() < Integer.MAX_VALUE ? regionToReparse.getLength() : this.editor.getTextViewer().getBottomIndexEndOffset() - reparseStart;
        Object object = this.syncRoot;
        synchronized (object) {
            int delta = event.getText().length() - event.getLength();
            if (delta > 0) {
                this.queuedForReparse.applyOffset(event.getOffset(), delta);
                this.enqueueToReparse(reparseStart, reparseLength);
            } else {
                ListNode keyOffsetsToRemove = null;
                OffsetKeyedTreeMap.NodesIterator<QueuedRegionInfo> it = this.queuedForReparse.nodesIteratorAt(reparseStart);
                if (it.getCurrValue() != null || it.prev()) {
                    int firstAffectedReparseOffset = it.getCurrOffset();
                    keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)firstAffectedReparseOffset);
                }
                while (it.next()) {
                    keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)it.getCurrOffset());
                }
                ListNode kn = keyOffsetsToRemove;
                while (kn != null) {
                    this.queuedForReparse.removeAt((Integer)kn.data);
                    kn = kn.next;
                }
                this.queuedForReparse.put(reparseStart, new QueuedRegionInfo(reparseLength));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueToReparse(int toParseStart, int toParseLength) {
        Object object = this.syncRoot;
        synchronized (object) {
            OffsetKeyedTreeMap.NodesIterator<QueuedRegionInfo> it = this.queuedForReparse.nodesIteratorAt(toParseStart);
            QueuedRegionInfo region = it.getCurrValue();
            int regionOffset = it.getCurrOffset();
            if (region == null && it.prev()) {
                region = it.getCurrValue();
                regionOffset = it.getCurrOffset();
            }
            if (region != null && regionOffset <= toParseStart && regionOffset + region.length > toParseStart) {
                region.length = Math.max(region.length, toParseStart + toParseLength - regionOffset);
            } else {
                this.queuedForReparse.put(toParseStart, new QueuedRegionInfo(toParseLength));
            }
        }
    }

    private void ensureVisibleRangeIsParsed() {
        int endOffset;
        TextViewer viewer = this.editor.getTextViewer();
        if (viewer == null) {
            return;
        }
        Interval knownRange = new Interval(this.knownRegionStart, this.knownRegionEnd);
        int startOffset = viewer.getTopIndexStartOffset();
        Interval visibleRange = new Interval(startOffset, endOffset = viewer.getBottomIndexEndOffset());
        if (!knownRange.properlyContains(visibleRange)) {
            Interval unknownRange = visibleRange.differenceNotProperlyContained(knownRange);
            if (unknownRange == null) {
                unknownRange = visibleRange;
            }
            this.enqueueToReparse(unknownRange.a, unknownRange.length());
            this.schedule(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(@Nullable DocumentEvent event) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getRuleManager() == null || !this.editor.isAdvancedHighlightingEnabled() || !SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                return;
            }
            this.task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        SQLBackgroundParsingJob.this.doWork();
                    }
                    catch (BadLocationException e) {
                        log.debug((Object)e);
                    }
                }
            };
            schedulingTimer.schedule(this.task, 500L * (long)(this.isRunning ? 2 : 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocument(@Nullable IDocument newDocument) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.document != null) {
                this.cancel();
            }
            if (newDocument != null && SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                this.document = newDocument;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.context.clear();
            this.queuedForReparse.clear();
            this.knownRegionEnd = 0;
            this.knownRegionStart = 0;
            this.ensureVisibleRangeIsParsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws BadLocationException {
        List elements;
        SQLParserContext parserContext;
        IProgressMonitor monitor;
        int workLength;
        int workOffset;
        TextViewer viewer;
        block25: {
            block24: {
                viewer = this.editor.getTextViewer();
                if (viewer == null || this.editor.getRuleManager() == null) {
                    return;
                }
                Interval visibleFragment = (Interval)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<Interval>(){

                    public Interval runWithResult() {
                        int startOffset = viewer.getTopIndexStartOffset();
                        int endOffset = viewer.getBottomIndexEndOffset();
                        return new Interval(startOffset, endOffset);
                    }
                });
                if (visibleFragment == null) {
                    return;
                }
                try {
                    Object object = this.syncRoot;
                    synchronized (object) {
                        this.task = null;
                        this.isRunning = true;
                        int stepsToKeep = 2;
                        int rangeStart = Math.max(0, visibleFragment.a - visibleFragment.length() * stepsToKeep);
                        int rangeEnd = Math.max(0, visibleFragment.b + visibleFragment.length() * stepsToKeep);
                        Interval actualFragment = new Interval(rangeStart, rangeEnd);
                        Interval preservedRegion = this.context.dropInvisibleScriptItems(actualFragment);
                        this.knownRegionStart = preservedRegion.a;
                        this.knownRegionEnd = preservedRegion.b;
                        OffsetKeyedTreeMap.NodesIterator<QueuedRegionInfo> it = this.queuedForReparse.nodesIteratorAt(0);
                        workOffset = it.getCurrValue() != null || it.next() ? it.getCurrOffset() : 0;
                        it = this.queuedForReparse.nodesIteratorAt(Integer.MAX_VALUE);
                        workLength = it.getCurrValue() != null || it.prev() ? it.getCurrOffset() + it.getCurrValue().length - workOffset : 0;
                        Interval workInterval = new Interval(workOffset, workOffset + workLength);
                        if (!actualFragment.properlyContains(workInterval)) {
                            workInterval = actualFragment.intersection(workInterval);
                            workOffset = workInterval.a;
                            workLength = workInterval.length();
                        }
                        this.queuedForReparse.clear();
                    }
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                    return;
                }
                monitor = Job.getJobManager().createProgressGroup();
                if (workLength != 0) break block24;
                monitor.done();
                return;
            }
            parserContext = new SQLParserContext(this.editor.getDataSource(), this.editor.getSyntaxManager(), this.editor.getRuleManager(), this.document);
            elements = SQLScriptParser.extractScriptQueries((SQLParserContext)parserContext, (int)workOffset, (int)workLength, (boolean)false, (boolean)false, (boolean)false);
            if (!elements.isEmpty()) break block25;
            monitor.done();
            return;
        }
        try {
            try {
                elements.set(0, SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)((SQLScriptElement)elements.get(0)).getOffset()));
                if (elements.size() > 1) {
                    int index = elements.size() - 1;
                    elements.set(index, SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)((SQLScriptElement)elements.get(index)).getOffset()));
                }
                SQLScriptElement lastElement = (SQLScriptElement)elements.get(elements.size() - 1);
                workOffset = ((SQLScriptElement)elements.get(0)).getOffset();
                workLength = lastElement.getOffset() + lastElement.getLength() - workOffset;
                boolean isReadMetadataForQueryAnalysis = this.editor.isReadMetadataForQueryAnalysisEnabled();
                DBCExecutionContext executionContext = this.editor.getExecutionContext();
                monitor.beginTask("Background query analysis", 1 + elements.size());
                monitor.worked(1);
                int i = 1;
                for (SQLScriptElement element : elements) {
                    if (monitor.isCanceled()) break;
                    try {
                        SQLQueryModelRecognizer recognizer = new SQLQueryModelRecognizer(executionContext, isReadMetadataForQueryAnalysis);
                        SQLQuerySelectionModel queryModel = recognizer.recognizeQuery(element.getOriginalText());
                        if (queryModel != null) {
                            SQLDocumentScriptItemSyntaxContext itemContext = this.context.registerScriptItemContext(element.getOffset(), element.getLength());
                            itemContext.clear();
                            for (SQLQuerySymbolEntry entry : queryModel.getAllSymbols()) {
                                itemContext.registerToken(entry.getInterval().a, entry);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        log.debug((Object)ex);
                    }
                    monitor.worked(1);
                    monitor.setTaskName("Background query analysis: subtask #" + i++);
                }
                this.context.resetLastAccessCache();
            }
            catch (Throwable ex) {
                log.debug((Object)ex);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
        monitor.done();
        int parsedOffset = workOffset;
        int parsedLength = workLength;
        Object object = this.syncRoot;
        synchronized (object) {
            this.knownRegionStart = Math.min(this.knownRegionStart, parsedOffset);
            this.knownRegionEnd = Math.max(this.knownRegionEnd, parsedOffset + parsedLength);
            this.isRunning = false;
        }
        UIUtils.asyncExec(() -> viewer.invalidateTextPresentation(parsedOffset, parsedLength));
    }

    private class DocumentLifecycleListener
    implements IDocumentListener,
    ITextInputListener,
    IViewportListener {
        private DocumentLifecycleListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.beforeDocumentModification(event);
        }

        public void documentChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.schedule(event);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                SQLBackgroundParsingJob.this.cancel();
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
                SQLBackgroundParsingJob.this.setDocument(newInput);
            }
        }

        public void viewportChanged(int verticalOffset) {
            SQLBackgroundParsingJob.this.ensureVisibleRangeIsParsed();
        }
    }

    private static class QueuedRegionInfo {
        public int length;

        public QueuedRegionInfo(int length) {
            this.length = length;
        }
    }
}

