/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.lsm.sql.dialect.LSMDialectRegistry;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMSkippingErrorListener;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.editors.sql.semantics.DirectedGraph;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataSourceContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsCrossJoinModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsNaturalJoinModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSelectionFilterModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSetCorrespondingOperationModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQuerySelectionModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueSubqueryExpression;
import org.jkiss.utils.Pair;

public class SQLQueryModelRecognizer {
    private final HashSet<SQLQuerySymbolEntry> symbolEntries = new HashSet();
    private final boolean isReadMetadataForSemanticAnalysis;
    private final DBCExecutionContext executionContext;
    private SQLQueryDataContext queryDataContext;
    private final SQLQueryRecognitionContext recognitionContext = new SQLQueryRecognitionContext(){

        @Override
        public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error, @NotNull DBException ex) {
        }

        @Override
        public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error) {
        }

        @Override
        public void appendError(@NotNull STMTreeNode treeNode, @NotNull String error) {
        }
    };
    private static final Set<String> columnNameListWrapperNames = Set.of(STMKnownRuleNames.correspondingSpec, STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.correlationSpecification, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.namedColumnsJoin, STMKnownRuleNames.joinSpecification, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.uniqueConstraintDefinition, STMKnownRuleNames.viewDefinition, STMKnownRuleNames.insertColumnsAndSource, STMKnownRuleNames.referenceColumnList, STMKnownRuleNames.referencingColumns, STMKnownRuleNames.derivedColumnList, STMKnownRuleNames.joinColumnList, STMKnownRuleNames.correspondingColumnList, STMKnownRuleNames.uniqueColumnList, STMKnownRuleNames.viewColumnList, STMKnownRuleNames.insertColumnList);
    private static final Set<String> identifierDirectWrapperNames = Set.of(STMKnownRuleNames.unqualifiedSchemaName, STMKnownRuleNames.catalogName, STMKnownRuleNames.correlationName, STMKnownRuleNames.authorizationIdentifier, STMKnownRuleNames.columnName);
    private static final Set<String> tableNameContainers = Set.of(STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.qualifier, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.explicitTable, STMKnownRuleNames.tableDefinition, STMKnownRuleNames.viewDefinition, STMKnownRuleNames.alterTableStatement, STMKnownRuleNames.dropTableStatement, STMKnownRuleNames.dropViewStatement, STMKnownRuleNames.deleteStatement, STMKnownRuleNames.insertStatement, STMKnownRuleNames.updateStatement);
    private static final Set<String> actualTableNameContainers = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.correlationName);
    private static final Set<String> qualifiedNameDirectWrapperNames = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.constraintName);
    private static final Set<String> knownValueExpressionRootNames = Set.of(STMKnownRuleNames.valueExpression, STMKnownRuleNames.searchCondition, STMKnownRuleNames.havingClause, STMKnownRuleNames.whereClause, STMKnownRuleNames.groupByClause, STMKnownRuleNames.orderByClause);
    private static final Set<String> knownRecognizableValueExpressionNames = Set.of(STMKnownRuleNames.subquery, STMKnownRuleNames.columnReference);

    public SQLQueryModelRecognizer(@Nullable DBCExecutionContext executionContext, boolean isReadMetadataForSemanticAnalysis) {
        this.isReadMetadataForSemanticAnalysis = isReadMetadataForSemanticAnalysis;
        this.executionContext = executionContext;
    }

    private void traverseForIdentifiers(@NotNull STMTreeNode root, @NotNull Consumer<SQLQuerySymbolEntry> columnAction, @NotNull Consumer<SQLQueryQualifiedName> entityAction) {
        List refs = STMUtils.expandSubtree((STMTreeNode)root, null, Set.of(STMKnownRuleNames.columnReference, STMKnownRuleNames.tableName));
        block4: for (STMTreeNode ref : refs) {
            switch (ref.getNodeKindId()) {
                case 86: {
                    SQLQueryQualifiedName tableName;
                    if (ref.getChildCount() > 1 && (tableName = this.collectTableName(ref.getStmChild(0))) != null) {
                        entityAction.accept(tableName);
                    }
                    columnAction.accept(this.collectIdentifier(ref.getStmChild(ref.getChildCount() - 1)));
                    break;
                }
                case 44: {
                    SQLQueryQualifiedName tableName = this.collectTableName(ref);
                    if (tableName == null) continue block4;
                    entityAction.accept(tableName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + ref.getNodeName());
                }
            }
        }
    }

    @NotNull
    private SQLQueryDataContext prepareDataContext(@NotNull STMTreeNode root) {
        if (this.isReadMetadataForSemanticAnalysis && this.executionContext != null && this.executionContext.getDataSource() instanceof DBSObjectContainer) {
            return new SQLQueryDataSourceContext(this.executionContext, this.executionContext.getDataSource().getSQLDialect());
        }
        HashSet<String> allColumnNames = new HashSet<String>();
        HashSet<List<String>> allTableNames = new HashSet<List<String>>();
        this.traverseForIdentifiers(root, c -> {
            boolean bl = allColumnNames.add(c.getName());
        }, e -> {
            boolean bl = allTableNames.add(e.toListOfStrings());
        });
        this.symbolEntries.clear();
        return new SQLQueryDummyDataSourceContext(allColumnNames, allTableNames);
    }

    @NotNull
    private SQLDialect obtainSqlDialect() {
        if (this.executionContext != null && this.executionContext.getDataSource() != null) {
            return this.executionContext.getDataSource().getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    @Nullable
    public SQLQuerySelectionModel recognizeQuery(@NotNull String text) {
        STMSource querySource = STMSource.fromString((String)text);
        LSMAnalyzer analyzer = LSMDialectRegistry.getInstance().getAnalyzerForDialect(this.obtainSqlDialect());
        STMTreeRuleNode tree = analyzer.parseSqlQueryTree(querySource, (STMErrorListener)new STMSkippingErrorListener());
        if (tree != null) {
            this.queryDataContext = this.prepareDataContext((STMTreeNode)tree);
            SQLQueryRowsSourceModel source = this.collectQueryExpression((STMTreeNode)tree);
            if (source != null) {
                SQLQuerySelectionModel model = new SQLQuerySelectionModel(source, this.symbolEntries);
                model.propagateContex(this.queryDataContext, this.recognitionContext);
                return model;
            }
            this.traverseForIdentifiers((STMTreeNode)tree, c -> c.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN), e -> {
                e.entityName.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE);
                if (e.schemaName != null) {
                    e.schemaName.getSymbol().setSymbolClass(SQLQuerySymbolClass.SCHEMA);
                    if (e.catalogName != null) {
                        e.catalogName.getSymbol().setSymbolClass(SQLQuerySymbolClass.CATALOG);
                    }
                }
            });
            return new SQLQuerySelectionModel(null, this.symbolEntries);
        }
        return null;
    }

    @Nullable
    private SQLQueryRowsSourceModel collectQueryExpression(@NotNull STMTreeNode tree) {
        QueryExpressionMapper queryMapper = new QueryExpressionMapper(this);
        return (SQLQueryRowsSourceModel)queryMapper.translate(tree);
    }

    @NotNull
    private List<SQLQuerySymbolEntry> collectColumnNameList(@NotNull STMTreeNode node) {
        if (!node.getNodeName().equals(STMKnownRuleNames.columnNameList)) {
            if (!columnNameListWrapperNames.contains(node.getNodeName())) {
                throw new UnsupportedOperationException("columnNameList (or its wrapper) expected while facing with " + node.getNodeName());
            }
            List actual = STMUtils.expandSubtree((STMTreeNode)node, columnNameListWrapperNames, Set.of(STMKnownRuleNames.columnNameList));
            switch (actual.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    node = (STMTreeNode)actual.get(0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Ambiguous columnNameList collection at " + node.getNodeName());
                }
            }
        }
        ArrayList<SQLQuerySymbolEntry> result = new ArrayList<SQLQuerySymbolEntry>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            result.add(this.collectIdentifier(node.getStmChild(i)));
            ++i;
        }
        return result;
    }

    @NotNull
    private SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node) {
        STMTreeNode actual;
        STMTreeNode sTMTreeNode = actual = identifierDirectWrapperNames.contains(node.getNodeName()) ? node.getStmChild(0) : node;
        if (!actual.getNodeName().equals(STMKnownRuleNames.identifier)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        String rawIdentifierString = actual.getTextContent();
        SQLDialect dialect = this.obtainSqlDialect();
        String actualIdentifierString = dialect.isQuotedIdentifier(rawIdentifierString) ? rawIdentifierString : (dialect.mustBeQuoted(rawIdentifierString, false) ? dialect.getQuotedIdentifier(rawIdentifierString, false, false) : rawIdentifierString.toLowerCase());
        SQLQuerySymbolEntry entry = new SQLQuerySymbolEntry(actual.getRealInterval(), actualIdentifierString);
        this.symbolEntries.add(entry);
        return entry;
    }

    @NotNull
    private SQLQueryRowsTableDataModel collectTableReference(@NotNull STMTreeNode node) {
        return new SQLQueryRowsTableDataModel(this.collectTableName(node));
    }

    @Nullable
    private SQLQueryQualifiedName collectTableName(@NotNull STMTreeNode node) {
        List actual = STMUtils.expandSubtree((STMTreeNode)node, tableNameContainers, actualTableNameContainers);
        return switch (actual.size()) {
            case 0 -> null;
            case 1 -> {
                node = (STMTreeNode)actual.get(0);
                if (node.getNodeName().equals(STMKnownRuleNames.tableName)) {
                    yield this.collectQualifiedName(node);
                }
                yield new SQLQueryQualifiedName(this.collectIdentifier(node));
            }
            default -> throw new UnsupportedOperationException("Ambiguous tableName collection at " + node.getNodeName());
        };
    }

    @NotNull
    private SQLQueryQualifiedName collectQualifiedName(@NotNull STMTreeNode node) {
        STMTreeNode entityNameNode;
        STMTreeNode sTMTreeNode = entityNameNode = qualifiedNameDirectWrapperNames.contains(node.getNodeName()) ? node.getStmChild(0) : node;
        if (!entityNameNode.getNodeName().equals(STMKnownRuleNames.qualifiedName)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        SQLQuerySymbolEntry entityName = this.collectIdentifier(entityNameNode.getStmChild(entityNameNode.getChildCount() - 1));
        if (entityNameNode.getChildCount() == 1) {
            return new SQLQueryQualifiedName(entityName);
        }
        STMTreeNode schemaNameNode = entityNameNode.getStmChild(0);
        SQLQuerySymbolEntry schemaName = this.collectIdentifier(schemaNameNode.getStmChild(schemaNameNode.getChildCount() - 1));
        if (schemaNameNode.getChildCount() == 1) {
            return new SQLQueryQualifiedName(schemaName, entityName);
        }
        STMTreeNode catalogNameNode = schemaNameNode.getStmChild(0);
        SQLQuerySymbolEntry catalogName = this.collectIdentifier(catalogNameNode.getStmChild(catalogNameNode.getChildCount() - 1));
        return new SQLQueryQualifiedName(catalogName, schemaName, entityName);
    }

    @NotNull
    private SQLQueryValueExpression collectValueExpression(@NotNull STMTreeNode node) {
        if (!knownValueExpressionRootNames.contains(node.getNodeName())) {
            throw new UnsupportedOperationException("Search condition or value expression expected while facing with " + node.getNodeName());
        }
        List knownExprs = STMUtils.expandSubtree((STMTreeNode)node, null, knownRecognizableValueExpressionNames);
        return knownExprs.size() == 1 ? this.collectKnownValueExpression((STMTreeNode)knownExprs.get(0)) : new SQLQueryValueFlattenedExpression(knownExprs.stream().map(this::collectKnownValueExpression).collect(Collectors.toList()));
    }

    @NotNull
    private SQLQueryValueExpression collectKnownValueExpression(@NotNull STMTreeNode node) {
        return switch (node.getNodeKindId()) {
            case 95 -> new SQLQueryValueSubqueryExpression(this.collectQueryExpression(node));
            case 86 -> {
                SQLQuerySymbolEntry columnName = this.collectIdentifier(node.getStmChild(node.getChildCount() - 1));
                if (node.getChildCount() == 1) {
                    yield new SQLQueryValueColumnReferenceExpression(columnName);
                }
                yield new SQLQueryValueColumnReferenceExpression(this.collectTableName(node.getStmChild(0)), columnName);
            }
            default -> throw new UnsupportedOperationException("Subquery of columnReference expected while facing with " + node.getNodeName());
        };
    }

    static /* synthetic */ SQLQueryValueExpression access$0(SQLQueryModelRecognizer sQLQueryModelRecognizer, STMTreeNode sTMTreeNode) {
        return sQLQueryModelRecognizer.collectValueExpression(sTMTreeNode);
    }

    private static class DebugGraphBuilder {
        private final DirectedGraph graph = new DirectedGraph();
        private final LinkedList<Pair<Object, Object>> stack = new LinkedList();
        private final Set<Object> done = new HashSet<Object>();
        private final Map<Object, DirectedGraph.Node> objs = new HashMap<Object, DirectedGraph.Node>();

        private DebugGraphBuilder() {
        }

        /*
         * WARNING - void declaration
         */
        private void expandObject(Object prev, Object o) {
            Object node;
            Object src;
            String propName = prev == null ? null : (String)((Pair)prev).getFirst();
            Object object = src = prev == null ? null : ((Pair)prev).getSecond();
            if (o instanceof SQLQueryDataContext || o instanceof SQLQueryRowsSourceModel || o instanceof SQLQueryValueExpression) {
                node = this.objs.get(o);
                DirectedGraph.Node prevNode = this.objs.get(src);
                if (node == null) {
                    String color = o instanceof SQLQueryDataContext ? "#bbbbff" : (o instanceof SQLQueryRowsSourceModel ? "#bbffbb" : (o instanceof SQLQueryValueExpression ? "#ffbbbb" : "#bbbbbb"));
                    node = this.graph.createNode(o.toString().substring(o.getClass().getPackageName().length()), color);
                    this.objs.put(o, (DirectedGraph.Node)node);
                }
                if (prevNode != null) {
                    this.graph.createEdge(prevNode, (DirectedGraph.Node)node, propName, null);
                }
                src = o;
                propName = "";
            }
            if (this.done.contains(o)) {
                return;
            }
            this.done.add(o);
            if (o instanceof String || o.getClass().isPrimitive() || o.getClass().isEnum()) {
                return;
            }
            if (o instanceof SQLQuerySymbol || o instanceof DBSObject || o instanceof DBCExecutionContext) {
                return;
            }
            Object object2 = o;
            if (object2 instanceof Iterable && (node = (Iterable)object2) == (Iterable)object2) {
                return;
            }
            Class<?> t = o.getClass();
            while (t != Object.class) {
                Field[] fieldArray = t.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    try {
                        Object x;
                        if ((f.canAccess(o) || f.trySetAccessible()) && (x = f.get(o)) != null) {
                            if (x instanceof String || x.getClass().isEnum()) {
                                prevNode = this.objs.get(src);
                                if (prevNode != null) {
                                    String text = x.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("\n", "&#10;");
                                    ((DirectedGraph.Node)prevNode).label = String.valueOf(((DirectedGraph.Node)prevNode).label) + "&#10;" + propName + "." + f.getName() + " = " + text;
                                }
                            } else {
                                 instanceOfPatternExpressionValue = x;
                                if ( instanceOfPatternExpressionValue instanceof Iterable && (prevNode = (Iterable) instanceOfPatternExpressionValue) == (Iterable) instanceOfPatternExpressionValue) {
                                    void it;
                                    int index = 0;
                                    for (Object y : it) {
                                        if (y == null || this.done.contains(y)) continue;
                                        this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(String.valueOf(propName) + "[" + index++ + "]"), src), y));
                                    }
                                } else {
                                    this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(String.valueOf(propName) + "." + f.getName()), src), x));
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
                t = t.getSuperclass();
            }
        }

        public void traverseObjs(Object obj) {
            this.stack.addLast((Pair<Object, Object>)new Pair(null, obj));
            while (this.stack.size() > 0) {
                Pair<Object, Object> p = this.stack.removeLast();
                this.expandObject(p.getFirst(), p.getSecond());
            }
        }
    }

    private static class QueryExpressionMapper
    extends TreeMapper<SQLQueryRowsSourceModel, SQLQueryModelRecognizer> {
        private static final Set<String> queryExpressionSubtreeNodeNames = Set.of(STMKnownRuleNames.sqlQuery, STMKnownRuleNames.directSqlDataStatement, STMKnownRuleNames.selectStatement, STMKnownRuleNames.subquery, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.nonJoinQueryExpression, STMKnownRuleNames.nonJoinQueryTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.nonJoinQueryPrimary, STMKnownRuleNames.simpleTable, STMKnownRuleNames.querySpecification, STMKnownRuleNames.tableExpression, STMKnownRuleNames.queryPrimary, STMKnownRuleNames.queryTerm, STMKnownRuleNames.queryExpression, STMKnownRuleNames.selectStatementSingleRow, STMKnownRuleNames.fromClause, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.tableReference, STMKnownRuleNames.joinedTable, STMKnownRuleNames.derivedTable, STMKnownRuleNames.tableSubquery, STMKnownRuleNames.crossJoinTerm, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.explicitTable);
        private static final Map<String, TreeMapperCallback<SQLQueryRowsSourceModel, SQLQueryModelRecognizer>> translations = Map.ofEntries(Map.entry(STMKnownRuleNames.queryExpression, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable();
            }
            SQLQueryRowsSourceModel source = (SQLQueryRowsSourceModel)cc.get(0);
            int i = 1;
            while (i < cc.size()) {
                STMTreeNode childNode = n.getStmChild(i);
                List<SQLQuerySymbolEntry> corresponding = r.collectColumnNameList(childNode);
                SQLQueryRowsSourceModel nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                source = switch (childNode.getNodeKindId()) {
                    case 97 -> new SQLQueryRowsSetCorrespondingOperationModel(source, nextSource, corresponding);
                    case 96 -> new SQLQueryRowsSetCorrespondingOperationModel(source, nextSource, corresponding);
                    default -> throw new UnsupportedOperationException("Unexpected child node kind at queryExpression");
                };
                ++i;
            }
            return source;
        }), Map.entry(STMKnownRuleNames.nonJoinQueryTerm, QueryExpressionMapper::lambda$1), Map.entry(STMKnownRuleNames.joinedTable, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable();
            }
            SQLQueryRowsSourceModel source = (SQLQueryRowsSourceModel)cc.get(0);
            int i = 1;
            while (i < cc.size()) {
                SQLQueryRowsSourceModel currSource = source;
                SQLQueryRowsSourceModel nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                STMTreeNode childNode = n.getStmChild(i);
                source = switch (childNode.getNodeKindId()) {
                    case 123 -> Optional.ofNullable(childNode.findChildOfName(STMKnownRuleNames.joinSpecification)).map(cn -> cn.findChildOfName(STMKnownRuleNames.joinCondition)).map(cn -> cn.findChildOfName(STMKnownRuleNames.searchCondition)).map(cn -> r.collectValueExpression((STMTreeNode)cn)).map(e -> new SQLQueryRowsNaturalJoinModel(currSource, nextSource, (SQLQueryValueExpression)e)).orElseGet(() -> new SQLQueryRowsNaturalJoinModel(currSource, nextSource, r.collectColumnNameList(childNode)));
                    case 122 -> new SQLQueryRowsCrossJoinModel(currSource, nextSource);
                    default -> throw new UnsupportedOperationException("Unexpected child node kind at queryExpression");
                };
                ++i;
            }
            return source;
        }), Map.entry(STMKnownRuleNames.fromClause, QueryExpressionMapper::lambda$3), Map.entry(STMKnownRuleNames.tableExpression, (n, cc, r) -> {
            SQLQueryValueExpression whereExpr = Optional.ofNullable(n.findChildOfName(STMKnownRuleNames.whereClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
            SQLQueryValueExpression havingClause = Optional.ofNullable(n.findChildOfName(STMKnownRuleNames.havingClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
            SQLQueryValueExpression groupByClause = Optional.ofNullable(n.findChildOfName(STMKnownRuleNames.groupByClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
            SQLQueryValueExpression orderByClause = Optional.ofNullable(n.findChildOfName(STMKnownRuleNames.orderByClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
            SQLQueryRowsSourceModel source = cc.isEmpty() ? r.queryDataContext.getDefaultTable() : (SQLQueryRowsSourceModel)cc.get(0);
            return new SQLQueryRowsSelectionFilterModel(source, whereExpr, havingClause, groupByClause, orderByClause);
        }), Map.entry(STMKnownRuleNames.querySpecification, (n, cc, r) -> {
            STMTreeNode selectListNode = n.findChildOfName(STMKnownRuleNames.selectList);
            SQLQuerySelectionResultModel resultModel = new SQLQuerySelectionResultModel((selectListNode.getChildCount() + 1) / 2);
            int i = 0;
            while (i < selectListNode.getChildCount()) {
                STMTreeNode sublistNode;
                STMTreeNode selectSublist = selectListNode.getStmChild(i);
                if (selectSublist.getChildCount() > 0 && (sublistNode = selectSublist.getStmChild(0)) != null) {
                    switch (sublistNode.getNodeKindId()) {
                        case 107: {
                            SQLQueryValueExpression expr = r.collectValueExpression(sublistNode.getStmChild(0));
                            if (sublistNode.getChildCount() > 1) {
                                STMTreeNode asClause = sublistNode.getStmChild(1);
                                SQLQuerySymbolEntry asColumnName = r.collectIdentifier(asClause.getStmChild(asClause.getChildCount() - 1));
                                resultModel.addColumnSpec(expr, asColumnName);
                                break;
                            }
                            resultModel.addColumnSpec(expr);
                            break;
                        }
                        case 87: {
                            resultModel.addTupleSpec(r.collectTableName(sublistNode));
                            break;
                        }
                        case 262: {
                            break;
                        }
                        default: {
                            resultModel.addCompleteTupleSpec();
                        }
                    }
                }
                i += 2;
            }
            SQLQueryRowsSourceModel source = cc.isEmpty() ? r.queryDataContext.getDefaultTable() : (SQLQueryRowsSourceModel)cc.get(0);
            return new SQLQueryRowsProjectionModel(source, resultModel);
        }), Map.entry(STMKnownRuleNames.nonjoinedTableReference, (n, cc, r) -> {
            STMTreeNode lastSubnode;
            STMTreeNode tableNameNode;
            SQLQueryRowsSourceModel source = cc.isEmpty() ? ((tableNameNode = n.findChildOfName(STMKnownRuleNames.tableName)) != null ? r.collectTableReference(tableNameNode) : r.queryDataContext.getDefaultTable()) : (SQLQueryRowsSourceModel)cc.get(0);
            if (n.getChildCount() > 1 && (lastSubnode = n.getStmChild(n.getChildCount() - 1)).getNodeName().equals(STMKnownRuleNames.correlationSpecification)) {
                SQLQuerySymbolEntry correlationName = r.collectIdentifier(lastSubnode.getStmChild(lastSubnode.getChildCount() == 1 || lastSubnode.getChildCount() == 4 ? 0 : 1));
                source = new SQLQueryRowsCorrelatedSourceModel(source, correlationName, r.collectColumnNameList(lastSubnode));
            }
            return source;
        }), Map.entry(STMKnownRuleNames.explicitTable, (n, cc, r) -> r.collectTableReference(n)), Map.entry(STMKnownRuleNames.tableValueConstructor, (n, cc, r) -> new SQLQueryRowsTableValueModel()));

        public QueryExpressionMapper(SQLQueryModelRecognizer recognizer) {
            super(SQLQueryRowsSourceModel.class, queryExpressionSubtreeNodeNames, translations, recognizer);
        }

        /*
         * Unable to fully structure code
         */
        private static /* synthetic */ SQLQueryRowsSourceModel lambda$1(STMTreeNode n, List cc, SQLQueryModelRecognizer r) {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable();
            }
            source = (SQLQueryRowsSourceModel)cc.get(0);
            i = 1;
            while (i < cc.size()) {
                childNode = n.getStmChild(i);
                corresponding = r.collectColumnNameList(childNode);
                nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                switch (childNode.getNodeKindId()) {
                    case 100: {
                        ** break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected child node kind at nonJoinQueryTerm");
                    }
lbl-1000:
                    // 1 sources

                    {
                        source = new SQLQueryRowsSetCorrespondingOperationModel(source, nextSource, corresponding);
                    }
                }
                ++i;
            }
            return source;
        }

        /*
         * Unable to fully structure code
         */
        private static /* synthetic */ SQLQueryRowsSourceModel lambda$3(STMTreeNode n, List cc, SQLQueryModelRecognizer r) {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable();
            }
            source = (SQLQueryRowsSourceModel)cc.get(0);
            i = 1;
            while (i < cc.size()) {
                childNode = n.getStmChild(1 + i * 2);
                nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                switch (childNode.getNodeKindId()) {
                    case 115: {
                        ** break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected child node kind at fromClause");
                    }
lbl-1000:
                    // 1 sources

                    {
                        source = new SQLQueryRowsCrossJoinModel(source, nextSource);
                    }
                }
                ++i;
            }
            return source;
        }
    }

    private static class TreeMapper<T, C> {
        private final Class<T> mappingResultType;
        private final Set<String> transparentNodeNames;
        private final Map<String, TreeMapperCallback<T, C>> translations;
        private final Stack<MapperFrame> stack = new Stack();
        private final C context;

        public TreeMapper(@NotNull Class<T> mappingResultType, @NotNull Set<String> transparentNodeNames, @NotNull Map<String, TreeMapperCallback<T, C>> translations, @NotNull C context) {
            this.mappingResultType = mappingResultType;
            this.transparentNodeNames = transparentNodeNames;
            this.translations = translations;
            this.context = context;
        }

        public T translate(@NotNull STMTreeNode root) {
            MapperRootFrame rootFrame = new MapperRootFrame(root);
            this.stack.push(rootFrame);
            while (this.stack.size() > 0) {
                this.stack.pop().doWork();
            }
            return rootFrame.result;
        }

        private class MapperDataPendingNodeFrame
        extends MapperNodeFrame
        implements MapperResultFrame<T> {
            public final List<T> childrenData;
            public final TreeMapperCallback<T, C> translation;

            public MapperDataPendingNodeFrame(@NotNull STMTreeNode node, @NotNull MapperResultFrame<T> parent, TreeMapperCallback<T, C> translation) {
                super(node, parent);
                this.childrenData = new LinkedList();
                this.translation = translation;
            }

            @Override
            public void aggregate(@NotNull T result) {
                this.childrenData.add(result);
            }

            @Override
            public void doWork() {
                this.parent.aggregate(this.translation.apply(this.node, this.childrenData, TreeMapper.this.context));
            }
        }

        private static interface MapperFrame {
            public void doWork();
        }

        private abstract class MapperNodeFrame
        implements MapperFrame {
            public final STMTreeNode node;
            public final MapperResultFrame<T> parent;

            public MapperNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
                this.node = node;
                this.parent = parent;
            }
        }

        private class MapperQueuedNodeFrame
        extends MapperNodeFrame {
            public MapperQueuedNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
                super(node, parent);
            }

            @Override
            public void doWork() {
                MapperResultFrame aggregator;
                TreeMapperCallback translation = TreeMapper.this.translations.get(this.node.getNodeName());
                MapperResultFrame mapperResultFrame = aggregator = translation == null ? this.parent : new MapperDataPendingNodeFrame(this.node, this.parent, translation);
                if (translation != null) {
                    TreeMapper.this.stack.push(aggregator);
                }
                int i = this.node.getChildCount() - 1;
                while (i >= 0) {
                    if (TreeMapper.this.transparentNodeNames.contains(this.node.getNodeName())) {
                        TreeMapper.this.stack.push(new MapperQueuedNodeFrame((STMTreeNode)this.node.getChild(i), aggregator));
                    }
                    --i;
                }
            }
        }

        private static interface MapperResultFrame<T>
        extends MapperFrame {
            public void aggregate(T var1);
        }

        private class MapperRootFrame
        implements MapperResultFrame<T> {
            public final STMTreeNode node;
            public T result = null;

            public MapperRootFrame(STMTreeNode node) {
                this.node = node;
            }

            @Override
            public void aggregate(@NotNull T result) {
                this.result = result;
            }

            @Override
            public void doWork() {
                TreeMapper.this.stack.push(new MapperQueuedNodeFrame(this.node, this));
            }
        }
    }

    @FunctionalInterface
    private static interface TreeMapperCallback<T, C> {
        public T apply(STMTreeNode var1, List<T> var2, C var3);
    }
}

