/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.context;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public class SQLQueryCombinedContext
extends SQLQueryResultTupleContext {
    private final SQLQueryDataContext otherParent;

    public SQLQueryCombinedContext(@NotNull SQLQueryDataContext left, @NotNull SQLQueryDataContext right) {
        super(left, SQLQueryCombinedContext.combineColumns(left.getColumnsList(), right.getColumnsList()));
        this.otherParent = right;
    }

    @Override
    @NotNull
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.findRealSource(table), this.otherParent.findRealSource(table));
    }

    @Override
    @NotNull
    public DBSEntity findRealTable(@NotNull List<String> tableName) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.findRealTable(tableName), this.otherParent.findRealTable(tableName));
    }

    @Override
    @NotNull
    public SourceResolutionResult resolveSource(@NotNull List<String> tableName) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.resolveSource(tableName), this.otherParent.resolveSource(tableName));
    }

    @NotNull
    private static List<SQLQuerySymbol> combineColumns(@NotNull List<SQLQuerySymbol> leftColumns, @NotNull List<SQLQuerySymbol> rightColumns) {
        ArrayList<SQLQuerySymbol> symbols = new ArrayList<SQLQuerySymbol>(leftColumns.size() + rightColumns.size());
        symbols.addAll(leftColumns);
        symbols.addAll(rightColumns);
        return symbols;
    }

    private static <T> T anyOfTwo(T a, T b) {
        return a != null ? a : b;
    }
}

