/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public class SQLQueryRowsSetCorrespondingOperationModel
extends SQLQueryRowsSetOperationModel {
    private final List<SQLQuerySymbolEntry> correspondingColumnNames;

    public SQLQueryRowsSetCorrespondingOperationModel(@NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @NotNull List<SQLQuerySymbolEntry> correspondingColumnNames) {
        super(left, right);
        this.correspondingColumnNames = correspondingColumnNames;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        ArrayList<SQLQuerySymbol> resultColumns;
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(context, statistics);
        boolean nonMatchingColumnSets = false;
        if (this.correspondingColumnNames.isEmpty()) {
            List<SQLQuerySymbol> leftColumns = left.getColumnsList();
            List<SQLQuerySymbol> rightColumns = right.getColumnsList();
            resultColumns = new ArrayList(Math.max(leftColumns.size(), rightColumns.size()));
            int i = 0;
            while (i < resultColumns.size()) {
                if (i >= leftColumns.size()) {
                    resultColumns.add(rightColumns.get(i));
                    nonMatchingColumnSets = true;
                } else if (i >= rightColumns.size()) {
                    resultColumns.add(leftColumns.get(i));
                    nonMatchingColumnSets = true;
                } else {
                    resultColumns.add(leftColumns.get(i).merge(rightColumns.get(i)));
                }
                ++i;
            }
        } else {
            resultColumns = new ArrayList<SQLQuerySymbol>(this.correspondingColumnNames.size());
            int i = 0;
            while (i < resultColumns.size()) {
                SQLQuerySymbolEntry column = this.correspondingColumnNames.get(i);
                SQLQuerySymbolDefinition leftDef = left.resolveColumn(column.getName());
                SQLQuerySymbolDefinition rightDef = right.resolveColumn(column.getName());
                if (leftDef == null || rightDef == null) {
                    nonMatchingColumnSets = true;
                }
                column.getSymbol().setDefinition(column);
                resultColumns.add(column.getSymbol());
                ++i;
            }
        }
        if (nonMatchingColumnSets) {
            statistics.appendError((STMTreeNode)null, "UNION, EXCEPT and INTERSECT require subsets column tuples to match");
        }
        return this.correspondingColumnNames.isEmpty() ? left : context.overrideResultTuple(resultColumns);
    }
}

