/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import org.jkiss.dbeaver.dpi.model.DPIController;
import org.jkiss.dbeaver.dpi.model.client.BundleProcessConfig;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.osgi.framework.Bundle;

public class BundleConfigGenerator {
    public static void generateBundleConfig(List<Bundle> bundles) {
        LinkedHashSet<Bundle> dependencies = new LinkedHashSet<Bundle>();
        for (Bundle bundle : bundles) {
            BundleConfigGenerator.collectBundleDependencies(bundle, dependencies);
        }
        System.out.println(dependencies);
    }

    private static void collectBundleDependencies(Bundle bundle, Set<Bundle> dependencies) {
        dependencies.add(bundle);
    }

    public static BundleProcessConfig generateBundleConfig(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer) throws IOException {
        BundleProcessConfig processConfig = new BundleProcessConfig(monitor, dataSourceContainer.getId());
        BundleConfigGenerator.addBundleFromClass(dataSourceContainer.getDriver().getDataSourceProvider().getClass(), processConfig);
        if (!processConfig.isValid()) {
            throw new IOException("No OSGI bundles were configured");
        }
        BundleConfigGenerator.addBundleFromClass(DPIController.class, processConfig);
        DBAAuthModel authModel = dataSourceContainer.getConnectionConfiguration().getAuthModel();
        BundleConfigGenerator.addBundleFromClass(authModel.getClass(), processConfig);
        BundleConfigGenerator.addBundleByName("org.jkiss.dbeaver.dpi.app", processConfig);
        BundleConfigGenerator.addBundleByName("com.dbeaver.resources.drivers.jdbc", processConfig);
        processConfig.generateApplicationConfiguration();
        return processConfig;
    }

    private static void addBundleByName(String bundleName, BundleProcessConfig processConfig) {
        ModuleWiring wiring;
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle instanceof EquinoxBundle && (wiring = ((EquinoxBundle)bundle).getModule().getCurrentRevision().getWiring()) != null) {
            BundleConfigGenerator.collectModuleWirings(wiring, processConfig);
        }
    }

    private static void addBundleFromClass(Class<?> bundleClass, BundleProcessConfig processConfig) {
        ModuleWiring wiring;
        ClassLoader classLoader = bundleClass.getClassLoader();
        if (classLoader instanceof EquinoxClassLoader && (wiring = ((EquinoxClassLoader)classLoader).getBundleLoader().getWiring()) != null) {
            BundleConfigGenerator.collectModuleWirings(wiring, processConfig);
        }
    }

    private static void collectModuleWirings(ModuleWiring wiring, BundleProcessConfig processConfig) {
        ModuleWiring providerWiring;
        if (processConfig.containsWiring(wiring)) {
            return;
        }
        processConfig.addWiring(wiring);
        List requiredModuleWires = wiring.getRequiredModuleWires("osgi.wiring.bundle");
        for (ModuleWire dWire : requiredModuleWires) {
            providerWiring = dWire.getProviderWiring();
            BundleConfigGenerator.collectModuleWirings(providerWiring, processConfig);
        }
        for (ModuleWire dWire : wiring.getRequiredModuleWires("osgi.wiring.package")) {
            providerWiring = dWire.getProviderWiring();
            BundleConfigGenerator.collectModuleWirings(providerWiring, processConfig);
        }
    }
}

