/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreUserMapping;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreForeignServer
extends PostgreInformation
implements PostgreScriptObject {
    private long oid;
    private String name;
    private String type;
    private String version;
    private String[] options;
    private long ownerId;
    private long dataWrapperId;
    private UserMappingCache userMappingCache = new UserMappingCache();

    public PostgreForeignServer(PostgreDatabase database) {
        super(database);
    }

    public PostgreForeignServer(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"srvowner");
        this.dataWrapperId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"srvfdw");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvtype");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvversion");
        this.options = PostgreUtils.safeGetStringArray(dbResult, "srvoptions");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=3)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=4)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=5)
    public String[] getOptions() {
        return this.options;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Association
    public Collection<PostgreUserMapping> getUserMappings(DBRProgressMonitor monitor) throws DBException {
        return this.userMappingCache.getAllObjects(monitor, this);
    }

    public PostgreUserMapping getUserMapping(DBRProgressMonitor monitor, long oid) throws DBException {
        return (PostgreUserMapping)PostgreUtils.getObjectById(monitor, this.userMappingCache, this, oid);
    }

    @Property(viewable=false, order=8)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(viewable=true, order=10)
    public PostgreForeignDataWrapper getForeignDataWrapper(DBRProgressMonitor monitor) throws DBException {
        return (PostgreForeignDataWrapper)PostgreUtils.getObjectById(monitor, this.getDatabase().foreignDataWrapperCache, this.getDatabase(), this.dataWrapperId);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return "-- Foreign server: " + this.getName() + "\n\n" + "-- DROP SERVER " + this.getName() + ";\n\n" + "CREATE SERVER " + this.getName() + "\n\t" + "FOREIGN DATA WRAPPER " + this.getForeignDataWrapper(monitor).getName() + "\n\t" + "OPTIONS " + PostgreUtils.getOptionsString(this.options);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    static class UserMappingCache
    extends JDBCObjectCache<PostgreForeignServer, PostgreUserMapping> {
        UserMappingCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreForeignServer owner) throws SQLException {
            return session.prepareStatement("select distinct \nsrvname, \ncase when rolname is null then 'public' else rolname end rolname, \nsrvoptions,  \numoptions  \nfrom pg_user_mapping um  \njoin pg_foreign_server fs on um.umserver = fs.OID  \nleft join pg_authid pa on um.umuser = pa.OID \nwhere fs.OID = " + owner.getObjectId() + "\nORDER BY srvname");
        }

        protected PostgreUserMapping fetchObject(@NotNull JDBCSession session, @NotNull PostgreForeignServer owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreUserMapping(owner, (ResultSet)dbResult);
        }
    }
}

