/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreNativeToolHandler;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseBackupHandler
extends PostgreNativeToolHandler<PostgreDatabaseBackupSettings, DBSObject, PostgreDatabaseBackupInfo> {
    public Collection<PostgreDatabaseBackupInfo> getRunInfo(PostgreDatabaseBackupSettings settings) {
        return settings.getExportObjects();
    }

    protected PostgreDatabaseBackupSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        PostgreDatabaseBackupSettings settings = new PostgreDatabaseBackupSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, PostgreDatabaseBackupSettings settings, Log log) {
        if (task.getType().getId().equals("pgDatabaseBackup")) {
            for (PostgreDatabaseBackupInfo exportObject : settings.getExportObjects()) {
                String dir = settings.getOutputFolder(exportObject);
                try {
                    Path outputFolderPath = DBFUtils.resolvePathFromString((DBRProgressMonitor)new VoidProgressMonitor(), (DBPProject)task.getProject(), (String)dir);
                    if (Files.exists(outputFolderPath, new LinkOption[0])) continue;
                    Files.createDirectories(outputFolderPath, new FileAttribute[0]);
                }
                catch (Exception e) {
                    log.error((Object)("Can't create directory '" + dir + "'"), (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean needsModelRefresh() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    protected boolean isLogInputStream() {
        return false;
    }

    @Override
    protected boolean isExportWizard() {
        return true;
    }

    @Override
    public void fillProcessParameters(PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg, List<String> cmd) throws IOException {
        block10: {
            block11: {
                super.fillProcessParameters(settings, arg, cmd);
                cmd.add("--format=" + settings.getFormat().getId());
                if (!CommonUtils.isEmpty((String)settings.getCompression())) {
                    cmd.add("--compress=" + settings.getCompression());
                }
                if (!CommonUtils.isEmpty((String)settings.getEncoding())) {
                    cmd.add("--encoding=" + settings.getEncoding());
                }
                if (settings.isUseInserts()) {
                    cmd.add("--inserts");
                }
                if (settings.isNoPrivileges()) {
                    cmd.add("--no-privileges");
                }
                if (settings.isNoOwner()) {
                    cmd.add("--no-owner");
                }
                if (settings.isDropObjects()) {
                    cmd.add("--clean");
                }
                if (settings.isCreateDatabase()) {
                    cmd.add("--create");
                }
                if (!this.isUseStreamTransfer(settings.getOutputFile(arg)) || settings.getFormat() == PostgreBackupRestoreSettings.ExportFormat.DIRECTORY) {
                    cmd.add("--file");
                    cmd.add(settings.getOutputFile(arg));
                }
                if (settings.getExportObjects().isEmpty()) break block10;
                if (CommonUtils.isEmpty(arg.getTables())) break block11;
                for (PostgreTableBase table : arg.getTables()) {
                    cmd.add("-t");
                    cmd.add(PostgreDatabaseBackupHandler.escapeCLIIdentifier(table.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                }
                break block10;
            }
            if (CommonUtils.isEmpty(arg.getSchemas())) break block10;
            for (PostgreSchema schema : arg.getSchemas()) {
                cmd.add("-n");
                cmd.add(PostgreDatabaseBackupHandler.escapeCLIIdentifier(DBUtils.getQuotedIdentifier((DBSObject)schema)));
            }
        }
    }

    protected List<String> getCommandLine(PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(settings, arg, cmd);
        cmd.add(arg.getDatabase().getName());
        return cmd;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException, DBException {
        super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
        String outFileName = settings.getOutputFile(arg);
        if (this.isUseStreamTransfer(outFileName) && settings.getFormat() != PostgreBackupRestoreSettings.ExportFormat.DIRECTORY) {
            Path outFile = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)task.getProject(), (String)outFileName);
            AbstractNativeToolHandler.DumpCopierJob job = new AbstractNativeToolHandler.DumpCopierJob(monitor, "Export database", process.getInputStream(), outFile, log);
            job.start();
        }
    }
}

