/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.ExtensionMap;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntroExtensionContent
extends AbstractIntroElement {
    protected static final String TAG_CONTAINER_EXTENSION = "extensionContent";
    protected static final String TAG_CONTAINER_REPLACE = "replacementContent";
    public static final int TYPE_CONTRIBUTION = 0;
    public static final int TYPE_REPLACEMENT = 1;
    protected static final String ATT_PATH = "path";
    protected static final String ATT_ID = "id";
    private static final String ATT_STYLE = "style";
    private static final String ATT_ALT_STYLE = "alt-style";
    private static final String ATT_CONTENT = "content";
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    private String path;
    private String content;
    private String contentFile;
    private String contentId;
    private String anchorId;
    private Element element;
    private String base;
    private Vector<String> styles = new Vector();
    private Map<String, Bundle> altStyles = new HashMap<String, Bundle>();

    IntroExtensionContent(Element element, Bundle bundle, String base, IConfigurationElement configExtElement) {
        super(element, bundle);
        this.path = this.getAttribute(element, ATT_PATH);
        this.content = this.getAttribute(element, ATT_CONTENT);
        this.anchorId = this.getAttribute(element, ATT_ID);
        this.element = element;
        this.base = base;
        this.init(element, bundle, base);
        if (this.content != null) {
            IPath subBase = ModelUtil.getParentFolderPath(this.content);
            String newBase = IPath.fromOSString((String)base).append(subBase).toString();
            this.extractFileAndId(bundle);
            this.contentFile = BundleUtil.getResolvedResourceLocation(base, this.contentFile, bundle);
            this.base = newBase;
        }
        String contributor = configExtElement.getContributor().getName();
        ExtensionMap.getInstance().putPluginId(this.anchorId, contributor);
    }

    public String getId() {
        return this.anchorId;
    }

    private void init(Element element, Bundle bundle, String base) {
        String[] altStyleValues;
        String[] styleValues = this.getAttributeList(element, ATT_STYLE);
        if (styleValues != null && styleValues.length > 0) {
            int i = 0;
            while (i < styleValues.length) {
                String style = styleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addStyle(style);
                ++i;
            }
        }
        if ((altStyleValues = this.getAttributeList(element, ATT_ALT_STYLE)) != null && altStyleValues.length > 0) {
            int i = 0;
            while (i < altStyleValues.length) {
                String style = altStyleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addAltStyle(style, bundle);
                ++i;
            }
        }
    }

    protected void addStyle(String style) {
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(style);
    }

    protected void addAltStyle(String altStyle, Bundle bundle) {
        if (this.altStyles.containsKey(altStyle)) {
            return;
        }
        this.altStyles.put(altStyle, bundle);
    }

    public int getExtensionType() {
        return TAG_CONTAINER_REPLACE.equals(this.element.getNodeName()) ? 1 : 0;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int getType() {
        return 1024;
    }

    protected Element[] getChildren() {
        NodeList nodeList = this.element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                vector.add(node);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        this.element = null;
        return filteredElements;
    }

    public boolean isXHTMLContent() {
        return this.content != null;
    }

    public Element[] getElements() {
        IntroContentParser parser;
        Document dom;
        if (this.isXHTMLContent() && (dom = (parser = new IntroContentParser(this.contentFile)).getDocument()) != null && parser.hasXHTMLContent()) {
            if (this.contentId != null) {
                return new Element[]{ModelUtil.getElementById(dom, this.contentId)};
            }
            Element extensionBody = ModelUtil.getBodyElement(dom);
            return ModelUtil.getElementsByTagName(extensionBody, "*");
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Map<String, Bundle> getAltStyles() {
        return this.altStyles;
    }

    protected String[] getStyles() {
        Object[] stylesArray = new String[this.styles.size()];
        this.styles.copyInto(stylesArray);
        return stylesArray;
    }

    public String getContent() {
        return this.content;
    }

    public String getBase() {
        return this.base;
    }

    private void extractFileAndId(Bundle bundle) {
        IPath resourcePath = IPath.fromOSString((String)(this.base + this.content));
        if (FileLocator.find((Bundle)bundle, (IPath)resourcePath, null) != null) {
            this.contentFile = this.content;
        } else {
            int lastSlashIndex = this.content.lastIndexOf(47);
            if (lastSlashIndex != -1) {
                this.contentFile = this.content.substring(0, lastSlashIndex);
                this.contentId = this.content.substring(lastSlashIndex + 1);
            } else {
                this.contentFile = this.content;
            }
        }
    }
}

