/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.reflect.TypeToken;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RequestParameter;
import org.jkiss.utils.rest.RestConstants;
import org.jkiss.utils.rest.RestException;

public class RestServer<T> {
    private static final Logger log = Logger.getLogger(RestServer.class.getName());
    private HttpServer server;

    public RestServer(@NotNull Class<T> cls, @NotNull T object, @NotNull Gson gson, @NotNull Predicate<InetSocketAddress> filter, int port, int backlog) throws IOException {
        InetSocketAddress listenAddr = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
        this.server = HttpServer.create(listenAddr, backlog);
        this.server.createContext("/", this.createHandler(cls, object, gson, filter));
        this.server.setExecutor(this.createExecutor());
        this.server.start();
    }

    @NotNull
    public static <T> Builder<T> builder(@NotNull Class<T> cls, @NotNull T object) {
        return new Builder<T>(object, cls);
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public void stop() {
        this.stop(1);
    }

    public void stop(int delay) {
        try {
            this.server.stop(delay);
            Executor executor = this.server.getExecutor();
            if (executor instanceof ExecutorService) {
                ((ExecutorService)executor).shutdown();
            }
        }
        finally {
            this.server = null;
        }
    }

    @NotNull
    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    @NotNull
    protected Executor createExecutor() {
        return new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @NotNull
    protected RequestHandler<T> createHandler(@NotNull Class<T> cls, @NotNull T object, @NotNull Gson gson, @NotNull Predicate<InetSocketAddress> filter) {
        return new RequestHandler<T>(cls, object, gson, filter);
    }

    public static final class Builder<T> {
        private static final Predicate<InetSocketAddress> DEFAULT_PREDICATE = address -> true;
        private final T object;
        private final Class<T> cls;
        private Gson gson;
        private int port;
        private int backlog;
        private Predicate<InetSocketAddress> filter = DEFAULT_PREDICATE;

        private Builder(@NotNull T object, @NotNull Class<T> cls) {
            this.object = object;
            this.cls = cls;
            this.gson = RestConstants.DEFAULT_GSON;
            this.port = 0;
            this.backlog = 0;
        }

        @NotNull
        public Builder<T> setGson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        @NotNull
        public Builder<T> setPort(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder<T> setBacklog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        @NotNull
        public Builder<T> setFilter(@NotNull Predicate<InetSocketAddress> filter) {
            this.filter = filter;
            return this;
        }

        @NotNull
        public RestServer<T> create() {
            try {
                return new RestServer<T>(this.cls, this.object, this.gson, this.filter, this.port, this.backlog);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static class RequestHandler<T>
    implements HttpHandler {
        private static final Type REQUEST_TYPE = new TypeToken<Map<String, JsonElement>>(){}.getType();
        private final T object;
        private final Gson gson;
        private final Map<String, Method> mappings;
        private final Predicate<InetSocketAddress> filter;

        protected RequestHandler(@NotNull Class<T> cls, @NotNull T object, @NotNull Gson gson, @NotNull Predicate<InetSocketAddress> filter) {
            this.object = object;
            this.gson = gson;
            this.mappings = this.createMappings(cls);
            this.filter = filter;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            block20: {
                try {
                    response /* !! */  = this.createResponse(exchange);
                }
                catch (IOException e) {
                    RestServer.log.log(Level.SEVERE, "IO error", e);
                    response /* !! */  = new Response<String>(e.getMessage(), (Type)String.class, 500);
                }
                try {
                    block21: {
                        responseObject /* !! */  = response /* !! */ .object;
                        if (responseObject /* !! */  == null) {
                            responseObject /* !! */  = "Internal error";
                        }
                        if (response /* !! */ .code != 200) ** GOTO lbl48
                        if (response /* !! */ .type != Void.TYPE) break block21;
                        responseText = CommonUtils.toString(response /* !! */ .object);
                        exchange.getResponseHeaders().add("Content-Type", "text/plain");
                        ** GOTO lbl28
                    }
                    try {
                        responseText = this.gson.toJson(response /* !! */ .object, response /* !! */ .type);
                    }
                    catch (Throwable e) {
                        buf = new StringWriter();
                        new RestException("JSON serialization error: " + e.getMessage(), e).printStackTrace(new PrintWriter((Writer)buf, true));
                        this.sendError(exchange, 500, buf.toString());
                        exchange.close();
                        return;
                    }
                    try {
                        exchange.getResponseHeaders().add("Content-Type", "application/json");
lbl28:
                        // 2 sources

                        responseBytes = responseText.getBytes(StandardCharsets.UTF_8);
                        exchange.sendResponseHeaders(200, responseBytes.length);
                        var6_10 = null;
                        var7_12 = null;
                        try {
                            responseBody = exchange.getResponseBody();
                            try {
                                responseBody.write(responseBytes);
                                break block20;
                            }
                            finally {
                                if (responseBody != null) {
                                    responseBody.close();
                                }
                            }
                        }
                        catch (Throwable var7_13) {
                            if (var6_10 == null) {
                                var6_10 = var7_13;
                            } else if (var6_10 != var7_13) {
                                var6_10.addSuppressed(var7_13);
                            }
                            throw var6_10;
                        }
lbl48:
                        // 1 sources

                        this.sendError(exchange, response /* !! */ .code, responseObject /* !! */ );
                    }
                    catch (Throwable e) {
                        RestServer.log.log(Level.SEVERE, "Internal IO error", e);
                        throw e;
                    }
                }
                finally {
                    exchange.close();
                }
            }
        }

        private void sendError(HttpExchange exchange, int resultCode, Object responseObject) throws IOException {
            String responseText = responseObject.toString();
            byte[] result = responseText.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "text/plain");
            exchange.sendResponseHeaders(resultCode, result.length);
            Throwable throwable = null;
            Object var7_8 = null;
            try (OutputStream responseBody = exchange.getResponseBody();){
                responseBody.write(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        protected Response<?> createResponse(@NotNull HttpExchange exchange) throws IOException {
            Map request;
            if (!this.filter.test(exchange.getRemoteAddress())) {
                return new Response<String>("Access is forbidden", (Type)((Object)String.class), 403);
            }
            if (!exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                return new Response<String>("Unsupported method", (Type)((Object)String.class), 405);
            }
            URI uri = exchange.getRequestURI();
            String path = uri.getPath().replaceAll("^/+", "");
            Method method = this.mappings.get(path);
            if (method == null) {
                return new Response<String>("Mapping " + path + " not found", (Type)((Object)String.class), 404);
            }
            Throwable throwable = null;
            Object var7_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(exchange.getRequestBody()));){
                request = (Map)this.gson.fromJson((Reader)reader, REQUEST_TYPE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Parameter[] parameters = method.getParameters();
            Object[] values = new Object[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                Parameter p = parameters[i];
                RequestParameter param = p.getDeclaredAnnotation(RequestParameter.class);
                JsonElement element = (JsonElement)request.getOrDefault(param.value(), JsonNull.INSTANCE);
                values[i] = this.gson.fromJson(element, p.getParameterizedType());
                ++i;
            }
            try {
                Object result = method.invoke(this.object, values);
                Type type = method.getGenericReturnType();
                return new Response<Object>(result, type, 200);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                log.log(Level.SEVERE, "RPC call '" + uri + "' failed: " + e.getMessage());
                StringWriter buf = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)buf, true));
                return new Response<String>(buf.toString(), (Type)((Object)String.class), 500);
            }
        }

        @NotNull
        protected Map<String, Method> createMappings(@NotNull Class<T> cls) {
            HashMap<String, Method> mappings = new HashMap<String, Method>();
            Method[] methodArray = cls.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                RequestMapping mapping;
                Method method = methodArray[n2];
                if (method.getDeclaringClass() != Object.class && (mapping = method.getDeclaredAnnotation(RequestMapping.class)) != null) {
                    String methodEndpoint = mapping.value();
                    if (CommonUtils.isEmptyTrimmed(mapping.value())) {
                        methodEndpoint = method.getName();
                    }
                    if (mappings.containsKey(methodEndpoint)) {
                        log.warning("Method " + method + " has duplicate mapping, skipping");
                    } else {
                        method.setAccessible(true);
                        mappings.put(methodEndpoint, method);
                    }
                }
                ++n2;
            }
            return Collections.unmodifiableMap(mappings);
        }
    }

    private static class Response<T> {
        private final T object;
        private final Type type;
        private final int code;

        public Response(@Nullable T object, @NotNull Type type, int code) {
            this.object = object;
            this.type = type;
            this.code = code;
        }
    }
}

