/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.config;

import java.util.Collections;
import java.util.Map;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndexColumn;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class OracleIndexConfigurator
implements DBEObjectConfigurator<OracleTableIndex> {
    public OracleTableIndex configureObject(DBRProgressMonitor monitor, Object container, OracleTableIndex index, Map<String, Object> options) {
        return (OracleTableIndex)UITask.run(() -> {
            EditIndexPage editPage = new EditIndexPage(OracleUIMessages.edit_oracle_index_manager_dialog_title, (DBSTableIndex)index, Collections.singletonList(DBSIndexType.OTHER));
            if (!editPage.edit()) {
                return null;
            }
            StringBuilder idxName = new StringBuilder(64);
            idxName.append(CommonUtils.escapeIdentifier((String)((OracleTableBase)index.getTable()).getName())).append("_").append(CommonUtils.escapeIdentifier((String)((DBSEntityAttribute)editPage.getSelectedAttributes().iterator().next()).getName())).append("_IDX");
            index.setName(DBObjectNameCaseTransformer.transformName((DBPDataSource)index.getDataSource(), (String)idxName.toString()));
            index.setUnique(editPage.isUnique());
            index.setIndexType(editPage.getIndexType());
            int colIndex = 1;
            for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                index.addColumn(new OracleTableIndexColumn(index, (OracleTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc")), null));
            }
            return index;
        });
    }
}

