/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpression;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.lsm.mapping.AbstractSyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxModel;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxSubnodeLookupMode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.FieldTypeKind;
import org.jkiss.dbeaver.model.lsm.mapping.internal.LiteralTypeInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeTypeInfo;

public class NodeFieldInfo {
    public final FieldTypeKind kind;
    private final Field info;
    public final List<XPathExpression> termExprs;
    public final List<SubnodeInfo> subnodesInfo;
    private LiteralTypeInfo literalTypeInfo;

    public NodeFieldInfo(@NotNull FieldTypeKind kind, @NotNull Field info, @NotNull List<XPathExpression> termExprs, @NotNull List<SubnodeInfo> subnodesInfo) {
        this.kind = kind;
        this.info = info;
        this.termExprs = Collections.unmodifiableList(termExprs);
        this.subnodesInfo = Collections.unmodifiableList(subnodesInfo);
    }

    @NotNull
    public String getFieldName() {
        return this.info.getName();
    }

    @NotNull
    public String getDeclaringClassName() {
        return this.info.getDeclaringClass().getName();
    }

    public void fixup(@NotNull SyntaxModel syntaxModel) {
        this.literalTypeInfo = this.kind == FieldTypeKind.Enum ? syntaxModel.findLiteralTypeInfo(this.info.getType()) : null;
        for (SubnodeInfo subnodeInfo : this.subnodesInfo) {
            subnodeInfo.fixup(syntaxModel);
        }
    }

    public LiteralTypeInfo getLiteralTypeInfo() {
        if (this.literalTypeInfo == null) {
            throw new IllegalStateException();
        }
        return this.literalTypeInfo;
    }

    public Object getValue(AbstractSyntaxNode model) throws IllegalArgumentException, IllegalAccessException {
        return this.info.get(model);
    }

    public void setValue(AbstractSyntaxNode model, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.info.set(model, value);
    }

    public static class SubnodeInfo {
        public final XPathExpression scopeExpr;
        public final Class<? extends AbstractSyntaxNode> subnodeType;
        public final SyntaxSubnodeLookupMode lookupMode;
        private NodeTypeInfo nodeTypeInfo;

        public SubnodeInfo(@NotNull XPathExpression scopeExpr, @NotNull Class<? extends AbstractSyntaxNode> subnodeType, @NotNull SyntaxSubnodeLookupMode lookupMode) {
            this.scopeExpr = scopeExpr;
            this.subnodeType = subnodeType;
            this.lookupMode = lookupMode;
        }

        public void fixup(@NotNull SyntaxModel syntaxModel) {
            this.nodeTypeInfo = syntaxModel.findNodeTypeInfo(this.subnodeType);
        }

        @NotNull
        public NodeTypeInfo getNodeTypeInfo() {
            return this.nodeTypeInfo;
        }
    }
}

