/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class ClickhouseSQLDialect
extends GenericSQLDialect {
    private static final String[] CLICKHOUSE_FUNCTIONS = new String[]{"quantile", "quantileExact", "uniq", "concat", "replaceOne", "replaceAll", "toStartOfFifteenMinutes", "toStartOfFiveMinute", "toStartOfInterval", "toTimezone", "formatDateTime", "now", "multiIf", "geoToS2", "s2ToGeo", "greatCircleDistance", "greatCircleAngle", "plus", "minus", "multiply", "divide", "arrayConcat", "hasAll", "hasAny", "indexOf", "mapKeys", "mapValues", "UUIDNumToString", "UUIDStringToNum", "visitParamHas", "IPv4StringToNum", "randConstant", "javaHash", "bitmapBuild", "bitCount", "splitByChar", "splitByWhitespace", "toLowCardinality", "formatRow", "formatRow", "toDateTime64", "toUInt64", "toUInt128", "toUInt256", "toInt32", "toInt64", "toInt128", "sleep", "toString", "toDate", "toDateTime", "toDateOrNull", "toDateOrDefault", "toDateTimeOrZero", "toDateTimeOrNull", "toDateTimeOrDefault", "toDate32", "toDate32OrZero", "toDate32OrNull", "toDate32OrDefault", "timeZone", "timezoneOf", "toStartOfMonth", "parseDateTime", "parseDateTimeOrZero", "parseDateTimeOrNull", "parseDateTimeInJodaSyntax", "parseDateTimeInJodaSyntaxOrZero", "parseDateTimeInJodaSyntaxOrNull", "parseDateTimeBestEffort", "snowflakeToDateTime", "snowflakeToDateTime64", "dateTimeToSnowflake", "dateTime64ToSnowflake", "empty", "notEmpty", "trimLeft", "trimRight", "trimBoth", "startsWith", "endsWith", "isNull", "isNotNull", "ifNull", "nullIf", "assumeNotNull", "toNullable", "emptyArrayString", "arrayConcat", "arrayElement", "arrayJoin", "hasAll", "hasAny", "arraySort", "arrayReverseSort", "arrayMin", "arrayMax", "arraySum", "arrayAvg", "arrayStringConcat", "notLike", "notILike", "regexpExtract", "divideDecimal", "translate", "translateUTF8", "mapFromArrays", "mapAdd", "mapContains", "mapKeys", "mapValues", "mapFilter", "isValidJSON", "JSONHas", "JSONLength", "JSONExtractString", "JSONExtract", "JSONExtractKeysAndValues", "toJSONString", "JSONArrayLength", "dictGet", "dictGetOrDefault", "dictGetOrNull", "dictHas", "dictGetHierarchy", "dictIsIn", "dictGetChildren", "dictGetDescendant", "greatCircleDistance", "geoDistance", "greatCircleAngle", "pointInEllipses", "pointInPolygon", "geohashEncode", "geohashDecode", "geohashesInBox", "evalMLMethod", "stochasticLinearRegression", "stochasticLogisticRegression", "encrypt", "aes_encrypt_mysql", "decrypt", "tryDecrypt", "aes_decrypt_mysql", "queryStringAndFragment", "extractURLParameter", "L1Norm", "L2Norm", "LinfNorm", "LpNorm", "L1Distance", "L2Distance", "LinfDistance", "LpDistance", "L1Normalize", "L2Normalize", "LinfNormalize", "LpNormalize", "cosineDistance"};
    private static final String[] CLICKHOUSE_NONKEYWORDS = new String[]{"DEFAULT", "SYSTEM"};
    private static final String[] CLICKHOUSE_KEYWORDS = new String[]{"COMMENT", "REPLACE", "ENGINE", "SHOW"};

    public ClickhouseSQLDialect() {
        super("Clickhouse SQL", "clickhouse");
    }

    public boolean supportsOrderByIndex() {
        return false;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        String[] stringArray = CLICKHOUSE_NONKEYWORDS;
        int n = CLICKHOUSE_NONKEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            this.removeSQLKeyword(word);
            ++n2;
        }
        this.addFunctions(Arrays.asList(CLICKHOUSE_FUNCTIONS));
        this.addSQLKeywords(Arrays.asList(CLICKHOUSE_KEYWORDS));
        this.setIdentifierQuoteString(new String[][]{{"`", "`"}, {"\"", "\""}});
    }

    public boolean supportsSubqueries() {
        return true;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (typeName.equals("String")) {
            return null;
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public boolean supportsNestedComments() {
        return true;
    }

    public boolean mustBeQuoted(@NotNull String str, boolean forceCaseSensitive) {
        String[] stringArray = CLICKHOUSE_NONKEYWORDS;
        int n = CLICKHOUSE_NONKEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.equalsIgnoreCase(str)) {
                return true;
            }
            ++n2;
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!(!Character.isLetter((int)c) || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return true;
            }
            ++i;
        }
        return super.mustBeQuoted(str, forceCaseSensitive);
    }

    public char getStringEscapeCharacter() {
        return '\\';
    }

    @NotNull
    public String getTypeCastClause(@NotNull DBSTypedObject attribute, String expression, boolean isInCondition) {
        String typeName = attribute.getTypeName();
        if (isInCondition && CommonUtils.isNotEmpty((String)typeName) && "ipv4".equals(typeName.toLowerCase())) {
            return "IPv4StringToNum(" + expression + ")";
        }
        return super.getTypeCastClause(attribute, expression, isInCondition);
    }
}

