/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple.ui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsWizard;
import org.jkiss.dbeaver.tools.compare.simple.ui.internal.CompareUIMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

class CompareObjectsPageSettings
extends ActiveWizardPage<CompareObjectsWizard> {
    private Table nodesTable;
    private Button skipSystemObjects;
    private Button compareLazyProperties;
    private Button compareOnlyStructure;
    private Button compareScriptProperties;

    CompareObjectsPageSettings() {
        super(CompareUIMessages.compare_objects_page_settings_page);
        this.setTitle(CompareUIMessages.compare_objects_page_settings_title);
        this.setDescription(CompareUIMessages.compare_objects_page_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final CompareObjectsSettings settings = ((CompareObjectsWizard)this.getWizard()).getSettings();
        Group sourceSettings = new Group(composite, 0);
        sourceSettings.setText(CompareUIMessages.compare_objects_page_settings_group_objects);
        gl = new GridLayout(1, false);
        sourceSettings.setLayout((Layout)gl);
        sourceSettings.setLayoutData((Object)new GridData(1808));
        this.nodesTable = new Table((Composite)sourceSettings, 67588);
        this.nodesTable.setLayoutData((Object)new GridData(1808));
        this.nodesTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.nodesTable, (int)16384, (String)CompareUIMessages.compare_objects_page_settings_nodes_column_name);
        UIUtils.createTableColumn((Table)this.nodesTable, (int)16384, (String)CompareUIMessages.compare_objects_page_settings_nodes_column_type);
        UIUtils.createTableColumn((Table)this.nodesTable, (int)16384, (String)CompareUIMessages.compare_objects_page_settings_nodes_column_full_name);
        for (DBNDatabaseNode node : settings.getNodes()) {
            TableItem item = new TableItem(this.nodesTable, 0);
            item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
            item.setText(0, node.getNodeName());
            item.setText(1, node.getNodeTypeLabel());
            item.setText(2, node.getNodeFullName());
        }
        Group compareSettings = new Group(composite, 0);
        compareSettings.setText(CompareUIMessages.compare_objects_page_settings_group_settings);
        compareSettings.setLayoutData((Object)new GridData(768));
        compareSettings.setLayout((Layout)new GridLayout(1, false));
        this.skipSystemObjects = UIUtils.createCheckbox((Composite)compareSettings, (String)CompareUIMessages.compare_objects_page_settings_checkbox_skip_objects, (boolean)settings.isSkipSystemObjects());
        this.skipSystemObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setSkipSystemObjects(CompareObjectsPageSettings.this.skipSystemObjects.getSelection());
            }
        });
        this.compareLazyProperties = UIUtils.createCheckbox((Composite)compareSettings, (String)CompareUIMessages.compare_objects_page_settings_checkbox_compare_preporties, (boolean)settings.isCompareLazyProperties());
        this.compareLazyProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompareLazyProperties(CompareObjectsPageSettings.this.compareLazyProperties.getSelection());
            }
        });
        this.compareOnlyStructure = UIUtils.createCheckbox((Composite)compareSettings, (String)CompareUIMessages.compare_objects_page_settings_checkbox_compare_structure, (boolean)settings.isCompareOnlyStructure());
        this.compareOnlyStructure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompareOnlyStructure(CompareObjectsPageSettings.this.compareOnlyStructure.getSelection());
            }
        });
        this.compareScriptProperties = UIUtils.createCheckbox((Composite)compareSettings, (String)CompareUIMessages.compare_objects_page_settings_checkbox_scripts, (boolean)settings.isCompareScripts());
        this.compareScriptProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompareScripts(CompareObjectsPageSettings.this.compareScriptProperties.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        UIUtils.packColumns((Table)this.nodesTable, (boolean)true);
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

