/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.browser;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;

public class BrowserPopup
extends AbstractPopupPanel {
    private static final Log log = Log.getLog(BrowserPopup.class);
    private static final Map<String, Browser> browserRegistry = new HashMap<String, Browser>();
    private final String id;
    private final URL url;

    public static void openBrowser(@NotNull String id, @NotNull URL url) {
        Browser browser = browserRegistry.get(id);
        if (browser != null && !browser.isDisposed()) {
            browser.setUrl(url.toString());
        } else {
            BrowserPopup browserPopup = new BrowserPopup(UIUtils.getActiveShell(), id, url);
            browserPopup.open();
        }
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 800;
        composite.setLayoutData((Object)gd);
        try {
            Browser browser = new Browser(composite, 0);
            gd = new GridData(1808);
            gd.widthHint = 600;
            gd.heightHint = 500;
            browser.setLayoutData((Object)gd);
            browserRegistry.put(this.id, browser);
            browser.setUrl(this.url.toString());
        }
        catch (SWTError e) {
            log.error((Object)"Could not instantiate Browser", (Throwable)e);
        }
        return composite;
    }

    private BrowserPopup(@NotNull Shell parentShell, @NotNull String id, @NotNull URL url) {
        super(parentShell, "Browser");
        this.id = id;
        this.url = url;
        this.setModeless(false);
        this.setShellStyle(3184);
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent, int alignment) {
        if (alignment == 16384) {
            this.createButton(parent, 13, CoreMessages.popup_open_browser_open_external_browser, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            ShellUtils.launchProgram((String)this.url.toString());
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        browserRegistry.remove(this.id);
        return super.close();
    }
}

