/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageQueryManager
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.qm";
    private Button checkObjectTypeSessions;
    private Button checkObjectTypeTxn;
    private Button checkObjectTypeQueries;
    private Button checkQueryTypeUser;
    private Button checkQueryTypeUserFiltered;
    private Button checkQueryTypeScript;
    private Button checkQueryTypeUtil;
    private Button checkQueryTypeMeta;
    private Button checkQueryTypeDDL;
    private Text textHistoryDays;
    private Text textEntriesPerPage;
    private Button checkStoreLog;
    private Text textOutputFolder;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Composite filterSettings = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
        filterSettings.setLayoutData((Object)new GridData(768));
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Group groupQueryTypes = UIUtils.createControlGroup((Composite)filterSettings, (String)CoreMessages.pref_page_query_manager_group_query_types, (int)1, (int)770, (int)0);
        this.checkQueryTypeUser = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_user_queries, (boolean)false);
        this.checkQueryTypeUserFiltered = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_user_filtered, (boolean)false);
        this.checkQueryTypeScript = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_user_scripts, (boolean)false);
        this.checkQueryTypeUtil = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_utility_functions, (boolean)false);
        this.checkQueryTypeMeta = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_metadata_read, (boolean)false);
        this.checkQueryTypeDDL = UIUtils.createCheckbox((Composite)groupQueryTypes, (String)CoreMessages.pref_page_query_manager_checkbox_metadata_write, (boolean)false);
        Group groupObjects = UIUtils.createControlGroup((Composite)filterSettings, (String)CoreMessages.pref_page_query_manager_group_object_types, (int)1, (int)770, (int)0);
        this.checkObjectTypeSessions = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_query_manager_checkbox_sessions, (boolean)false);
        this.checkObjectTypeTxn = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_query_manager_checkbox_transactions, (boolean)false);
        this.checkObjectTypeQueries = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_query_manager_checkbox_queries, (boolean)false);
        Group viewSettings = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_query_manager_group_settings, (int)2, (int)770, (int)0);
        this.textEntriesPerPage = UIUtils.createLabelText((Composite)viewSettings, (String)CoreMessages.pref_page_query_manager_label_entries_per_page, (String)store.getString("qm.maxEntries"), (int)2048, (Object)new GridData(50, -1));
        Group storageSettings = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_query_manager_group_storage, (int)2, (int)770, (int)0);
        this.checkStoreLog = UIUtils.createCheckbox((Composite)storageSettings, (String)CoreMessages.pref_page_query_manager_checkbox_store_log_file, (boolean)store.getBoolean("qm.storeLogs"));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.checkStoreLog.setLayoutData((Object)gd);
        this.checkStoreLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.enableWithChildren((Control)PrefPageQueryManager.this.textOutputFolder.getParent(), (boolean)PrefPageQueryManager.this.checkStoreLog.getSelection());
                UIUtils.enableWithChildren((Control)PrefPageQueryManager.this.textHistoryDays, (boolean)PrefPageQueryManager.this.checkStoreLog.getSelection());
            }
        });
        this.textOutputFolder = DialogUtils.createOutputFolderChooser((Composite)storageSettings, (String)CoreMessages.pref_page_query_manager_logs_folder, null, (boolean)false, null);
        this.textOutputFolder.setText(store.getString("qm.logDirectory"));
        this.textHistoryDays = UIUtils.createLabelText((Composite)storageSettings, (String)CoreMessages.pref_page_query_manager_label_days_to_store_log, (String)store.getString("qm.historyDays"), (int)2048, (Object)new GridData(50, -1));
        Control infoLabel = UIUtils.createInfoLabel((Composite)storageSettings, (String)CoreMessages.pref_page_query_manager_log_file_hint);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.setSettings();
        return composite;
    }

    private void setSettings() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Collection objectTypes = QMObjectType.fromString((String)store.getString("qm.objectTypes"));
        List queryTypes = CommonUtils.splitString((String)store.getString("qm.queryTypes"), (char)',');
        this.checkObjectTypes(objectTypes);
        this.checkQueryTypes(queryTypes);
        UIUtils.enableWithChildren((Control)this.textOutputFolder.getParent(), (boolean)this.checkStoreLog.getSelection());
        UIUtils.enableWithChildren((Control)this.textHistoryDays, (boolean)this.checkStoreLog.getSelection());
    }

    private void checkObjectTypes(Collection<QMObjectType> objectTypes) {
        this.checkObjectTypeSessions.setSelection(objectTypes.contains(QMObjectType.session));
        this.checkObjectTypeTxn.setSelection(objectTypes.contains(QMObjectType.txn));
        this.checkObjectTypeQueries.setSelection(objectTypes.contains(QMObjectType.query));
    }

    private void checkQueryTypes(Collection<String> queryTypes) {
        this.checkQueryTypeUser.setSelection(queryTypes.contains(DBCExecutionPurpose.USER.name()));
        this.checkQueryTypeUserFiltered.setSelection(queryTypes.contains(DBCExecutionPurpose.USER_FILTERED.name()));
        this.checkQueryTypeScript.setSelection(queryTypes.contains(DBCExecutionPurpose.USER_SCRIPT.name()));
        this.checkQueryTypeUtil.setSelection(queryTypes.contains(DBCExecutionPurpose.UTIL.name()));
        this.checkQueryTypeMeta.setSelection(queryTypes.contains(DBCExecutionPurpose.META.name()));
        this.checkQueryTypeDDL.setSelection(queryTypes.contains(DBCExecutionPurpose.META_DDL.name()));
    }

    protected void performDefaults() {
        List<QMObjectType> objectTypes = Arrays.asList(QMObjectType.txn, QMObjectType.query);
        List<String> queryTypes = Arrays.asList(DBCExecutionPurpose.USER.name(), DBCExecutionPurpose.USER_FILTERED.name(), DBCExecutionPurpose.USER_SCRIPT.name());
        this.checkObjectTypes(objectTypes);
        this.checkQueryTypes(queryTypes);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.textHistoryDays.setText(store.getDefaultString("qm.historyDays"));
        this.textEntriesPerPage.setText(store.getDefaultString("qm.maxEntries"));
        this.checkStoreLog.setSelection(store.getDefaultBoolean("qm.storeLogs"));
        this.textOutputFolder.setText(store.getDefaultString("qm.logDirectory"));
        UIUtils.enableWithChildren((Control)this.textOutputFolder.getParent(), (boolean)this.checkStoreLog.getSelection());
        UIUtils.enableWithChildren((Control)this.textHistoryDays, (boolean)this.checkStoreLog.getSelection());
        super.performDefaults();
    }

    public boolean performOk() {
        ArrayList<QMObjectType> objectTypes = new ArrayList<QMObjectType>();
        ArrayList<String> queryTypes = new ArrayList<String>();
        if (this.checkObjectTypeSessions.getSelection()) {
            objectTypes.add(QMObjectType.session);
        }
        if (this.checkObjectTypeTxn.getSelection()) {
            objectTypes.add(QMObjectType.txn);
        }
        if (this.checkObjectTypeQueries.getSelection()) {
            objectTypes.add(QMObjectType.query);
        }
        if (this.checkQueryTypeUser.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.USER.name());
        }
        if (this.checkQueryTypeUserFiltered.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.USER_FILTERED.name());
        }
        if (this.checkQueryTypeScript.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.USER_SCRIPT.name());
        }
        if (this.checkQueryTypeUtil.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.UTIL.name());
        }
        if (this.checkQueryTypeMeta.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.META.name());
        }
        if (this.checkQueryTypeDDL.getSelection()) {
            queryTypes.add(DBCExecutionPurpose.META_DDL.name());
        }
        Integer historyDays = UIUtils.getTextInteger((Text)this.textHistoryDays);
        Integer entriesPerPage = UIUtils.getTextInteger((Text)this.textEntriesPerPage);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("qm.objectTypes", QMObjectType.toString(objectTypes));
        store.setValue("qm.queryTypes", CommonUtils.makeString(queryTypes, (char)','));
        if (historyDays != null) {
            store.setValue("qm.historyDays", Math.max(1, historyDays));
        }
        if (entriesPerPage != null) {
            store.setValue("qm.maxEntries", Math.max(1, entriesPerPage));
        }
        store.setValue("qm.storeLogs", this.checkStoreLog.getSelection());
        store.setValue("qm.logDirectory", this.textOutputFolder.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

