/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class NativeToolUtils {
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    public static final String VARIABLE_YEAR = "year";
    public static final String VARIABLE_MONTH = "month";
    public static final String VARIABLE_DAY = "day";
    public static final String VARIABLE_HOUR = "hour";
    public static final String VARIABLE_MINUTE = "minute";
    public static final String VARIABLE_CONN_TYPE = "connectionType";
    public static final String[] ALL_VARIABLES = new String[]{"host", "database", "table", "date", "timestamp", "year", "month", "day", "hour", "minute", "connectionType"};
    public static final String[] LIMITED_VARIABLES = new String[]{"host", "database", "date", "timestamp", "year", "month", "day", "hour", "minute", "connectionType"};

    public static boolean isSecureString(AbstractNativeToolSettings settings, String string) {
        String userPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        String toolUserPassword = settings.getToolUserPassword();
        return !CommonUtils.isEmpty((String)toolUserPassword) && string.endsWith(toolUserPassword) || !CommonUtils.isEmpty((String)userPassword) && string.endsWith(userPassword);
    }

    @NotNull
    public static String replaceVariables(@NotNull String name) {
        switch (name) {
            case "date": {
                return RuntimeUtils.getCurrentDate();
            }
            case "year": {
                return new SimpleDateFormat("yyyy").format(new Date());
            }
            case "month": {
                return new SimpleDateFormat("MM").format(new Date());
            }
            case "day": {
                return new SimpleDateFormat("dd").format(new Date());
            }
            case "hour": {
                return new SimpleDateFormat("HH").format(new Date());
            }
            case "minute": {
                return new SimpleDateFormat("mm").format(new Date());
            }
        }
        return System.getProperty(name);
    }
}

