/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;

class GridRowRenderer
extends AbstractRenderer {
    static final Image IMG_EXPAND = DBeaverIcons.getImage((DBPImage)UIIcon.TREE_EXPAND);
    static final Image IMG_COLLAPSE = DBeaverIcons.getImage((DBPImage)UIIcon.TREE_COLLAPSE);
    static final Rectangle EXPANDED_BOUNDS = IMG_EXPAND.getBounds();
    public static final int LEFT_MARGIN = 4;
    public static final int RIGHT_MARGIN = 4;
    public static final int IMAGE_SPACING = 5;
    public static final int EXPANDER_SPACING = 2;
    public static final int LEVEL_SPACING = GridRowRenderer.EXPANDED_BOUNDS.width;

    public GridRowRenderer(LightGrid grid) {
        super(grid);
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, int level, IGridContentProvider.ElementState state, IGridRow element) {
        String text = this.grid.getLabelProvider().getText(element);
        gc.setFont(this.grid.normalFont);
        gc.setBackground(this.grid.getLabelProvider().getHeaderBackground(element, selected));
        gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height + 1);
        gc.setForeground(this.grid.getLabelProvider().getHeaderBorder(element));
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        int x = 4;
        if (level > 0) {
            x += level * LEVEL_SPACING;
        }
        if (state != IGridContentProvider.ElementState.NONE) {
            Image expandImage = state == IGridContentProvider.ElementState.EXPANDED ? IMG_COLLAPSE : IMG_EXPAND;
            gc.drawImage(expandImage, x, bounds.y + (bounds.height - GridRowRenderer.EXPANDED_BOUNDS.height) / 2);
            x += GridRowRenderer.EXPANDED_BOUNDS.width + 2;
        } else if (this.grid.getContentProvider().isElementExpandable(element) && level == 0) {
            x += GridRowRenderer.EXPANDED_BOUNDS.width + 2;
        }
        Image image = this.grid.getLabelProvider().getImage(element);
        if (image != null) {
            gc.drawImage(image, x, bounds.y + (bounds.height - image.getBounds().height) / 2);
            x += image.getBounds().width + 5;
        }
        gc.setForeground(this.grid.getLabelProvider().getHeaderForeground(element, false));
        Font font = this.grid.getLabelProvider().getFont(element);
        if (font == null) {
            font = element == this.grid.getFocusRowElement() ? this.grid.boldFont : this.grid.normalFont;
        }
        gc.setFont(font);
        gc.drawString(UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)(bounds.width - x - 4)), bounds.x + x, bounds.y + (bounds.height - gc.stringExtent((String)text).y) / 2, isTransparent);
    }

    public int computeHeaderWidth(IGridRow element, int level) {
        Image rowImage;
        int width = 8;
        if (this.grid.getContentProvider().isElementExpandable(element)) {
            width += GridRowRenderer.EXPANDED_BOUNDS.width + 2;
        }
        if ((rowImage = this.grid.getLabelProvider().getImage(element)) != null) {
            width += rowImage.getBounds().width;
            width += 5;
        }
        String rowText = this.grid.getLabelProvider().getText(element);
        Point ext = this.grid.sizingGC.stringExtent(rowText);
        width += ext.x;
        return width += level * LEVEL_SPACING;
    }

    public static boolean isOverExpander(int x, int level) {
        int expandBegin = 4 + level * LEVEL_SPACING;
        int expandEnd = expandBegin + GridRowRenderer.EXPANDED_BOUNDS.width;
        return x >= expandBegin && x <= expandEnd;
    }
}

