/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.ConnectionFolderSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionNameResolver;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageInitialization;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageShellCommands;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionTypeLabelProvider;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionNavigatorSettingsDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionPermissionsDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.EditWizardPageDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.NavigatorSettingsStorage;
import org.jkiss.dbeaver.ui.navigator.dialogs.EditObjectFilterDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ConnectionPageGeneral
extends ConnectionWizardPage
implements NavigatorSettingsStorage {
    static final String PAGE_NAME = ConnectionPageGeneral.class.getSimpleName();
    private final ConnectionWizard wizard;
    private DataSourceDescriptor dataSourceDescriptor;
    private Text connectionNameText;
    private CSmartCombo<DBPConnectionType> connectionTypeCombo;
    private Combo navigatorSettingsCombo;
    private ConnectionFolderSelector folderSelector;
    private DBPDataSourceFolder curDataSourceFolder;
    private Text descriptionText;
    private boolean connectionNameChanged = false;
    private boolean activated = false;
    private Button readOnlyConnection;
    private DBNBrowseSettings navigatorSettings;
    private List<DBPDataSourcePermission> accessRestrictions;
    private List<FilterInfo> filters = new ArrayList<FilterInfo>();
    private Group filtersGroup;
    private Font boldFont;

    @Override
    public DBNBrowseSettings getNavigatorSettings() {
        return this.navigatorSettings;
    }

    @Override
    public void setNavigatorSettings(DBNBrowseSettings settings) {
        this.navigatorSettings = settings;
    }

    ConnectionPageGeneral(ConnectionWizard wizard) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.setTitle(CoreMessages.dialog_connection_edit_wizard_general);
        this.setDescription(CoreMessages.dialog_connection_wizard_final_description);
        this.filters.add(new FilterInfo(DBSCatalog.class, CoreMessages.dialog_connection_wizard_final_filter_catalogs));
        this.filters.add(new FilterInfo(DBSSchema.class, CoreMessages.dialog_connection_wizard_final_filter_schemas_users));
        this.filters.add(new FilterInfo(DBSTable.class, CoreMessages.dialog_connection_wizard_final_filter_tables));
        this.filters.add(new FilterInfo(DBSEntityAttribute.class, CoreMessages.dialog_connection_wizard_final_filter_attributes));
    }

    ConnectionPageGeneral(ConnectionWizard wizard, DataSourceDescriptor dataSourceDescriptor) {
        this(wizard);
        this.dataSourceDescriptor = dataSourceDescriptor;
        this.accessRestrictions = dataSourceDescriptor.getModifyPermission();
        for (FilterInfo filterInfo : this.filters) {
            filterInfo.filter = dataSourceDescriptor.getObjectFilter(filterInfo.type, null, true);
        }
    }

    protected boolean wasActivated() {
        return this.activated;
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    public void activatePage() {
        if (this.navigatorSettings == null) {
            this.navigatorSettings = new DataSourceNavigatorSettings(((ConnectionWizard)this.getWizard()).getSelectedNavigatorSettings());
        }
        if (this.connectionNameText != null) {
            ConnectionPageSettings settings = this.wizard.getPageSettings();
            if (this.dataSourceDescriptor != null && !CommonUtils.isEmpty((String)this.dataSourceDescriptor.getName())) {
                this.connectionNameText.setText(this.dataSourceDescriptor.getName());
            } else if (CommonUtils.isEmpty((String)this.connectionNameText.getText()) || !this.connectionNameChanged) {
                String newName = this.generateConnectionName(settings, ModelPreferences.getPreferences().getString("navigator.settings.default.connectionPattern"));
                if (!newName.isEmpty()) {
                    this.connectionNameText.setText(newName);
                }
                this.connectionNameChanged = false;
            }
        }
        this.folderSelector.loadConnectionFolders(((ConnectionWizard)this.getWizard()).getSelectedProject());
        if (this.dataSourceDescriptor != null) {
            DBPConnectionConfiguration conConfig = this.dataSourceDescriptor.getConnectionConfiguration();
            ConnectionPageGeneral.setConnectionType(this.connectionTypeCombo, conConfig.getConnectionType());
            ConnectionPageGeneral.updateNavigatorSettingsPreset(this.navigatorSettingsCombo, (DBNBrowseSettings)this.dataSourceDescriptor.getNavigatorSettings());
            this.folderSelector.setFolder((DBPDataSourceFolder)this.dataSourceDescriptor.getFolder());
            if (this.dataSourceDescriptor.getDescription() != null) {
                this.descriptionText.setText(this.dataSourceDescriptor.getDescription());
            }
            this.readOnlyConnection.setSelection(this.dataSourceDescriptor.isConnectionReadOnly());
            this.activated = true;
        } else {
            ConnectionPageGeneral.setConnectionType(this.connectionTypeCombo, DBPConnectionType.getDefaultConnectionType());
            ConnectionPageGeneral.updateNavigatorSettingsPreset(this.navigatorSettingsCombo, this.getNavigatorSettings());
            this.folderSelector.setFolder(this.curDataSourceFolder);
            this.readOnlyConnection.setSelection(false);
        }
        long features = ((ConnectionWizard)this.getWizard()).getSelectedDriver().getDataSourceProvider().getFeatures();
        for (FilterInfo filterInfo : this.filters) {
            if (DBSCatalog.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 1L) != 0L);
                continue;
            }
            if (DBSSchema.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 2L) != 0L);
                continue;
            }
            this.enableFilter(filterInfo, true);
        }
        this.filtersGroup.layout();
    }

    public static void updateNavigatorSettingsPreset(Combo navigatorSettingsCombo, DBNBrowseSettings navigatorSettings) {
        boolean isPreset = false;
        for (DataSourceNavigatorSettings.Preset nsEntry : DataSourceNavigatorSettings.PRESETS.values()) {
            if (!navigatorSettings.equals(nsEntry.getSettings())) continue;
            navigatorSettingsCombo.setText(nsEntry.getName());
            isPreset = true;
            break;
        }
        if (!isPreset) {
            navigatorSettingsCombo.select(navigatorSettingsCombo.getItemCount() - 1);
        }
    }

    private void enableFilter(FilterInfo filterInfo, boolean enable) {
        filterInfo.link.setEnabled(enable);
        if (enable) {
            filterInfo.link.setText("<a>" + filterInfo.title + "</a>");
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_tooltip, (Object)filterInfo.title));
            if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                filterInfo.link.setFont(this.boldFont);
            } else {
                filterInfo.link.setFont(this.getFont());
            }
        } else {
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_not_supported_tooltip, (Object)filterInfo.title, (Object)((ConnectionWizard)this.getWizard()).getSelectedDriver().getName()));
        }
    }

    private String generateConnectionName(ConnectionPageSettings settings, String usedName) {
        String newName;
        String resultName = usedName;
        if (settings != null) {
            if (resultName.isBlank()) {
                resultName = GeneralUtils.variablePattern((String)"host_or_database");
            }
            DataSourceDescriptor dataSource = settings.getActiveDataSource();
            DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
            ConnectionNameResolver resolver = new ConnectionNameResolver((DBPDataSourceContainer)dataSource, connectionInfo, this.dataSourceDescriptor);
            String baseName = newName = GeneralUtils.replaceVariables((String)resultName, (IVariableResolver)resolver);
            int i = 2;
            while (settings.getDataSourceRegistry().findDataSourceByName(newName) != null) {
                newName = String.valueOf(baseName) + " " + i;
                ++i;
            }
        } else {
            newName = this.wizard.getSelectedDriver().getName();
        }
        return newName;
    }

    @NotNull
    private DataSourceDescriptor getActiveDataSource() {
        ConnectionPageSettings pageSettings = ((ConnectionWizard)this.getWizard()).getPageSettings();
        return pageSettings == null ? this.wizard.getActiveDataSource() : pageSettings.getActiveDataSource();
    }

    public void deactivatePage() {
        this.saveSettings((DBPDataSourceContainer)this.dataSourceDescriptor);
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        Group miscGroup = UIUtils.createControlGroup((Composite)group, (String)CoreMessages.pref_page_ui_general_group_general, (int)2, (int)768, (int)0);
        String connectionName = this.dataSourceDescriptor == null ? "" : this.dataSourceDescriptor.getName();
        this.connectionNameText = UIUtils.createLabelText((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_label_connection_name, (String)CommonUtils.toString((Object)connectionName));
        this.connectionNameText.addModifyListener(e -> {
            if (this.dataSourceDescriptor == null || !this.connectionNameText.getText().equals(connectionName)) {
                this.connectionNameChanged = true;
                this.getContainer().updateButtons();
            }
        });
        ContentAssistUtils.installContentProposal((Control)this.connectionNameText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(ConnectionNameResolver.getConnectionVariables()).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        UIUtils.setContentProposalToolTip((Control)this.connectionNameText, (String)"Connection name patterns", (String[])ConnectionNameResolver.getConnectionVariables());
        this.connectionTypeCombo = ConnectionPageGeneral.createConnectionTypeCombo((Composite)miscGroup);
        this.connectionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType type = (DBPConnectionType)ConnectionPageGeneral.this.connectionTypeCombo.getItem(ConnectionPageGeneral.this.connectionTypeCombo.getSelectionIndex());
                ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).firePropertyChangeEvent("connection-type", ConnectionPageGeneral.this.getActiveDataSource().getConnectionConfiguration().getConnectionType(), type);
            }
        });
        final Composite ctGroup = this.connectionTypeCombo.getParent();
        ++((GridLayout)ctGroup.getLayout()).numColumns;
        UIUtils.createDialogButton((Composite)ctGroup, (String)CoreMessages.dialog_connection_wizard_final_label_connection_types_edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType curConType = (DBPConnectionType)ConnectionPageGeneral.this.connectionTypeCombo.getSelectedItem();
                DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                UIUtils.showPreferencesFor((Shell)ctGroup.getShell(), (Object)dataSource.getConnectionConfiguration().getConnectionType(), (String[])new String[]{"org.jkiss.dbeaver.preferences.connectionTypes"});
                ConnectionPageGeneral.loadConnectionTypes(ConnectionPageGeneral.this.connectionTypeCombo);
                if (!ConnectionPageGeneral.this.connectionTypeCombo.getItems().contains(curConType)) {
                    curConType = (DBPConnectionType)ConnectionPageGeneral.this.connectionTypeCombo.getItems().get(0);
                }
                ConnectionPageGeneral.setConnectionType(ConnectionPageGeneral.this.connectionTypeCombo, curConType);
                ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).firePropertyChangeEvent("connection-type", curConType, curConType);
            }
        });
        this.navigatorSettingsCombo = ConnectionPageGeneral.createNavigatorSettingsCombo((Composite)miscGroup, this, (DBPDataSourceContainer)this.dataSourceDescriptor);
        this.folderSelector = new ConnectionFolderSelector((Composite)miscGroup);
        Label descLabel = UIUtils.createControlLabel((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_description);
        descLabel.setLayoutData((Object)new GridData(2));
        this.descriptionText = new Text((Composite)miscGroup, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = this.descriptionText.getLineHeight() * 3;
        this.descriptionText.setLayoutData((Object)gd);
        Composite refsGroup = UIUtils.createComposite((Composite)group, (int)3);
        GridData gd2 = new GridData(768);
        refsGroup.setLayoutData((Object)gd2);
        Group securityGroup = UIUtils.createControlGroup((Composite)refsGroup, (String)CoreMessages.dialog_connection_wizard_final_group_security, (int)1, (int)34, (int)0);
        this.readOnlyConnection = UIUtils.createCheckbox((Composite)securityGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_connection_readonly, (this.dataSourceDescriptor != null && this.dataSourceDescriptor.isConnectionReadOnly() ? 1 : 0) != 0);
        this.readOnlyConnection.setLayoutData((Object)new GridData(32));
        UIUtils.createDialogButton((Composite)securityGroup, (String)"Edit permissions ...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageGeneral.this.editPermissions();
            }
        });
        this.filtersGroup = UIUtils.createControlGroup((Composite)refsGroup, (String)CoreMessages.dialog_connection_wizard_final_group_filters, (int)1, (int)34, (int)0);
        for (final FilterInfo filterInfo : this.filters) {
            filterInfo.link = UIUtils.createLink((Composite)this.filtersGroup, (String)("<a>" + filterInfo.title + "</a>"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditObjectFilterDialog dialog = new EditObjectFilterDialog(ConnectionPageGeneral.this.getShell(), ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).getDataSourceRegistry(), filterInfo.title, filterInfo.filter != null ? filterInfo.filter : new DBSObjectFilter(), true);
                    if (dialog.open() == 0) {
                        filterInfo.filter = dialog.getFilter();
                        if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.boldFont);
                        } else {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.getFont());
                        }
                    }
                }
            });
            filterInfo.link.setLayoutData((Object)new GridData(768));
        }
        Composite linkGroup = UIUtils.createComposite((Composite)refsGroup, (int)1);
        gd2 = new GridData(32);
        gd2.horizontalSpan = 2;
        linkGroup.setLayoutData((Object)gd2);
        Link initConfigLink = new Link(linkGroup, 0);
        initConfigLink.setText("<a>" + CoreMessages.dialog_connection_wizard_connection_init_description + "</a>");
        initConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).isNew()) {
                    DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                    EditWizardPageDialog dialog = new EditWizardPageDialog((ConnectionWizard)ConnectionPageGeneral.this.getWizard(), new ConnectionPageInitialization(dataSource), dataSource);
                    dialog.open();
                } else {
                    ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).openSettingsPage(ConnectionPageInitialization.PAGE_NAME);
                }
            }
        });
        initConfigLink.setLayoutData((Object)new GridData(32));
        Link shellConfigLink = new Link(linkGroup, 0);
        shellConfigLink.setText("<a>" + CoreMessages.dialog_connection_edit_wizard_shell_cmd + "</a>");
        shellConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).isNew()) {
                    DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                    EditWizardPageDialog dialog = new EditWizardPageDialog((ConnectionWizard)ConnectionPageGeneral.this.getWizard(), new ConnectionPageShellCommands(dataSource), dataSource);
                    dialog.open();
                } else {
                    ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).openSettingsPage(ConnectionPageShellCommands.PAGE_NAME);
                }
            }
        });
        shellConfigLink.setLayoutData((Object)new GridData(32));
        this.setControl((Control)group);
        UIUtils.setHelp((Control)group, (String)"con-wizard-final");
    }

    public static Combo createNavigatorSettingsCombo(Composite composite, final NavigatorSettingsStorage settingsStorage, final DBPDataSourceContainer dataSourceDescriptor) {
        UIUtils.createControlLabel((Composite)composite, (String)CoreMessages.dialog_connection_wizard_final_label_navigator_settings);
        Composite ctGroup = UIUtils.createComposite((Composite)composite, (int)2);
        final Combo navigatorSettingsCombo = new Combo(ctGroup, 2060);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)navigatorSettingsCombo) * 20;
        navigatorSettingsCombo.setLayoutData((Object)gd);
        for (String ncPresetName : DataSourceNavigatorSettings.PRESETS.keySet()) {
            navigatorSettingsCombo.add(ncPresetName);
        }
        navigatorSettingsCombo.select(0);
        navigatorSettingsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (navigatorSettingsCombo.getSelectionIndex() != navigatorSettingsCombo.getItemCount() - 1) {
                    DataSourceNavigatorSettings.Preset newSettings = (DataSourceNavigatorSettings.Preset)DataSourceNavigatorSettings.PRESETS.get(navigatorSettingsCombo.getText());
                    if (newSettings == null) {
                        throw new IllegalStateException("Invalid preset name: " + navigatorSettingsCombo.getText());
                    }
                    settingsStorage.setNavigatorSettings((DBNBrowseSettings)newSettings.getSettings());
                }
            }
        });
        UIUtils.createDialogButton((Composite)ctGroup, (String)CoreMessages.dialog_connection_wizard_final_label_navigator_settings_customize, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settingsStorage.setNavigatorSettings(ConnectionPageGeneral.editNavigatorSettings(navigatorSettingsCombo, settingsStorage.getNavigatorSettings(), dataSourceDescriptor));
            }
        });
        return navigatorSettingsCombo;
    }

    public static CSmartCombo<DBPConnectionType> createConnectionTypeCombo(Composite composite) {
        UIUtils.createControlLabel((Composite)composite, (String)CoreMessages.dialog_connection_wizard_final_label_connection_type);
        Composite ctGroup = UIUtils.createComposite((Composite)composite, (int)1);
        CSmartCombo connectionTypeCombo = new CSmartCombo(ctGroup, 2060, (ILabelProvider)new ConnectionTypeLabelProvider());
        ConnectionPageGeneral.loadConnectionTypes((CSmartCombo<DBPConnectionType>)connectionTypeCombo);
        ConnectionPageGeneral.setConnectionType((CSmartCombo<DBPConnectionType>)connectionTypeCombo, DBPConnectionType.getDefaultConnectionType());
        connectionTypeCombo.select((Object)DBPConnectionType.getDefaultConnectionType());
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)connectionTypeCombo) * 20;
        connectionTypeCombo.setLayoutData((Object)gd);
        return connectionTypeCombo;
    }

    private static DBNBrowseSettings editNavigatorSettings(@NotNull Combo navigatorSettingsCombo, @NotNull DBNBrowseSettings navigatorSettings, @Nullable DBPDataSourceContainer dataSourceDescriptor) {
        EditConnectionNavigatorSettingsDialog dialog = new EditConnectionNavigatorSettingsDialog(navigatorSettingsCombo.getShell(), navigatorSettings, dataSourceDescriptor);
        if (dialog.open() == 0) {
            navigatorSettings = dialog.getNavigatorSettings();
            ConnectionPageGeneral.updateNavigatorSettingsPreset(navigatorSettingsCombo, navigatorSettings);
        }
        return navigatorSettings;
    }

    private void editPermissions() {
        EditConnectionPermissionsDialog dialog = new EditConnectionPermissionsDialog(this.getShell(), this.accessRestrictions);
        if (dialog.open() == 0) {
            this.accessRestrictions = dialog.getAccessRestrictions();
        }
    }

    public static void setConnectionType(@NotNull CSmartCombo<DBPConnectionType> combo, @NotNull DBPConnectionType connectionType) {
        int i = 0;
        while (i < combo.getItemCount()) {
            DBPConnectionType item = (DBPConnectionType)combo.getItem(i);
            if (item.getId().equals(connectionType.getId())) {
                combo.select(i);
                return;
            }
            ++i;
        }
    }

    public static void loadConnectionTypes(CSmartCombo<DBPConnectionType> connectionTypeCombo) {
        connectionTypeCombo.removeAll();
        for (DBPConnectionType ct : DataSourceProviderRegistry.getInstance().getConnectionTypes()) {
            connectionTypeCombo.addItem((Object)ct);
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.dataSourceDescriptor != null && !this.activated) {
            return;
        }
        if (dataSource == null) {
            return;
        }
        DBPConnectionConfiguration confConfig = dataSource.getConnectionConfiguration();
        String name = this.connectionNameChanged ? this.generateConnectionName(((ConnectionWizard)this.getWizard()).getPageSettings(), this.connectionNameText.getText()) : (this.dataSourceDescriptor != null ? this.dataSourceDescriptor.getName() : this.generateConnectionName(((ConnectionWizard)this.getWizard()).getPageSettings(), ModelPreferences.getPreferences().getString("navigator.settings.default.connectionPattern")));
        dataSource.setName(name);
        if (this.folderSelector.isEmpty()) {
            dataSource.setFolder(this.curDataSourceFolder);
        } else {
            dataSource.setFolder(this.folderSelector.getFolder());
        }
        if (this.connectionTypeCombo.getSelectionIndex() >= 0) {
            confConfig.setConnectionType((DBPConnectionType)this.connectionTypeCombo.getSelectedItem());
        }
        DataSourceDescriptor dsDescriptor = (DataSourceDescriptor)dataSource;
        String description = this.descriptionText.getText();
        if (description.isEmpty()) {
            dsDescriptor.setDescription(null);
        } else {
            dsDescriptor.setDescription(description);
        }
        if (this.navigatorSettings == null) {
            this.navigatorSettings = new DataSourceNavigatorSettings(((ConnectionWizard)this.getWizard()).getSelectedNavigatorSettings());
        }
        dsDescriptor.setNavigatorSettings(this.navigatorSettings);
        dsDescriptor.setConnectionReadOnly(this.readOnlyConnection.getSelection());
        dsDescriptor.setModifyPermissions(this.accessRestrictions);
        for (FilterInfo filterInfo : this.filters) {
            if (filterInfo.filter == null) continue;
            dataSource.setObjectFilter(filterInfo.type, null, filterInfo.filter);
        }
    }

    public void setDataSourceFolder(DBPDataSourceFolder dataSourceFolder) {
        this.curDataSourceFolder = dataSourceFolder;
    }

    private static class FilterInfo {
        final Class<?> type;
        final String title;
        Link link;
        DBSObjectFilter filter;

        private FilterInfo(Class<?> type, String title) {
            this.type = type;
            this.title = title;
        }
    }
}

