/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarksHandlerImpl;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmark;

public class DBNBookmarkFolder
extends DBNResource {
    public DBNBookmarkFolder(DBNNode parentNode, IResource resource, DBPResourceHandler handler) throws DBException, CoreException {
        super(parentNode, resource, handler);
    }

    public DBPImage getNodeIcon() {
        IResource resource = this.getResource();
        if (resource != null && this.isRootResource(resource)) {
            return UIIcon.BOOKMARK_FOLDER;
        }
        return super.getNodeIcon();
    }

    public boolean supportsDrop(DBNNode otherNode) {
        if (otherNode instanceof DBNDatabaseNode || otherNode instanceof DBNBookmark) {
            return true;
        }
        return super.supportsDrop(otherNode);
    }

    public void dropNodes(Collection<DBNNode> nodes) throws DBException {
        for (DBNNode node : nodes) {
            if (node instanceof DBNDatabaseNode) {
                BookmarksHandlerImpl.createBookmark((DBNDatabaseNode)node, node.getNodeName(), (IFolder)this.getResource());
                continue;
            }
            if (!(node instanceof DBNBookmark)) continue;
            super.dropNodes(Collections.singleton(node));
        }
    }
}

