/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.datavirtuality.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.datavirtuality.views.DataVirtualityMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class DataVirtualityConnectionPage
extends ConnectionPageAbstract
implements IDialogPageProvider,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(DataVirtualityConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Button sslCheckbox;
    private Text dbText;
    private Text usernameText;
    private final Image logoImage = this.createImage("icons/datavirtuality_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite composite) {
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)DataVirtualityMessages.label_connection, (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)addrGroup, (String)DataVirtualityMessages.label_host);
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)DataVirtualityMessages.label_port);
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)DataVirtualityMessages.label_database);
        this.dbText = new Text((Composite)addrGroup, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)DataVirtualityMessages.label_ssl);
        this.sslCheckbox = new Button((Composite)addrGroup, 32);
        gd = new GridData(2);
        this.sslCheckbox.setLayoutData((Object)gd);
        addrGroup = UIUtils.createControlGroup((Composite)control, (String)DataVirtualityMessages.label_security, (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)addrGroup, (String)DataVirtualityMessages.label_user);
        this.usernameText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(800);
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)addrGroup, (int)2, (int)1);
        Text passwordText = this.createPasswordText((Composite)addrGroup, DataVirtualityMessages.label_password);
        gd = new GridData(800);
        passwordText.setLayoutData((Object)gd);
        passwordText.addModifyListener(textListener);
        this.createPasswordControls((Composite)addrGroup, 2);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText("localhost");
            } else {
                this.hostText.setText(connectionInfo.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "datavirtuality";
            }
            this.dbText.setText(databaseName);
        }
        if (this.sslCheckbox != null) {
            this.sslCheckbox.setSelection(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-ssl@")).equals("mms"));
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.sslCheckbox != null) {
            connectionInfo.setProviderProperty("@dbeaver-ssl@", this.sslCheckbox.getSelection() ? "mms" : "mm");
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dataSource);
    }

    public void testConnection(DBCSession session) {
        try {
            session.getProgressMonitor().subTask("Execute 'SELECT 1'");
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, "SELECT 1", false, false, false);){
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (DBCResultSet dbResult = dbStat.openResultSet();){
                    while (dbResult.nextRow()) {
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

