/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.console;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.console.ConsoleMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageConsoleView
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageConsoleView.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor.consoleview";
    private Button showConsoleViewByDefault;

    protected boolean hasDataSourceSpecificOptions(@NotNull DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.ConsoleView.showConsoleViewByDefault");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group commonGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_common, (int)2, (int)770, (int)0);
        this.showConsoleViewByDefault = UIUtils.createCheckbox((Composite)commonGroup, (String)ConsoleMessages.pref_page_console_view_label_show_output_console_view, (String)ConsoleMessages.pref_page_console_view_label_show_output_console_view_tip, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(@NotNull DBPPreferenceStore store) {
        try {
            this.showConsoleViewByDefault.setSelection(store.getBoolean("SQLEditor.ConsoleView.showConsoleViewByDefault"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(@NotNull DBPPreferenceStore store) {
        try {
            store.setValue("SQLEditor.ConsoleView.showConsoleViewByDefault", this.showConsoleViewByDefault.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(@NotNull DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.ConsoleView.showConsoleViewByDefault");
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

